/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.jobhandler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CountDataRedis2DBHandler {
    @Autowired
    Job countDataRedis2DBJob;
    @Autowired
    JobRepository jobRepository;
    private Logger logger = LoggerFactory.getLogger(CountDataRedis2DBHandler.class);

    @Scheduled(cron="10 0/1 * * * ?")
    public void execute() throws Exception {
        long time = System.currentTimeMillis();
        this.logger.info("CountDataRedis2DBHandler start:" + time);
        SimpleJobLauncher sjl = new SimpleJobLauncher();
        sjl.setJobRepository(this.jobRepository);
        sjl.afterPropertiesSet();
        JobParameters jobParameters = new JobParametersBuilder().addLong("time", Long.valueOf(time)).toJobParameters();
        JobExecution result = sjl.run(this.countDataRedis2DBJob, jobParameters);
        time = System.currentTimeMillis();
        this.logger.info("CountDataRedis2DBHandler start:" + time);
    }
}

