/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.listener;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component(value="jobRestartListener")
public class JobRestartListener
implements JobExecutionListener,
ApplicationContextAware {
    private Logger logger = LoggerFactory.getLogger(JobRestartListener.class);
    private ApplicationContext applicationContext;
    @Autowired
    private JobRepository jobRepository;

    public void beforeJob(JobExecution jobExecution) {
        this.logger.info(">>>>>>>>>>\u5f00\u59cb\u6267\u884c{}", (Object)jobExecution.getJobInstance().getJobName());
    }

    public void afterJob(JobExecution jobExecution) {
        if (!jobExecution.getExitStatus().getExitCode().equals(ExitStatus.COMPLETED.getExitCode())) {
            this.logger.error("{}\u4efb\u52a1\u7ed3\u675f\uff0c\u5f00\u59cb\u5c1d\u8bd5\u8fdb\u884c\u91cd\u542f\uff0c\u7ed3\u675f\u539f\u56e0\u4e3a{}", (Object)jobExecution.getJobInstance().getJobName(), (Object)jobExecution.getExitStatus().getExitDescription());
        }
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        Job job = (Job)this.applicationContext.getBean(jobExecution.getJobInstance().getJobName());
        try {
            SimpleJobLauncher sjl = new SimpleJobLauncher();
            sjl.setJobRepository(this.jobRepository);
            sjl.setTaskExecutor((TaskExecutor)new SimpleAsyncTaskExecutor());
            sjl.afterPropertiesSet();
            JobParametersBuilder jpb = new JobParametersBuilder();
            jpb.addLong("date", Long.valueOf(new Date().getTime()));
            sjl.run(job, jpb.toJobParameters());
        }
        catch (Exception e) {
            this.logger.error("\u4efb\u52a1" + jobExecution.getJobInstance().getJobName() + "\u91cd\u542f\u5931\u8d25", (Throwable)e);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

