/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import java.util.List;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisListWriter<T>
implements ItemStreamWriter<T> {
    private RedisTemplate redisTemplate;
    private String incrementKey;
    private String key;

    public RedisListWriter(RedisTemplate redisTemplate, String key) {
        this.redisTemplate = redisTemplate;
        this.key = key;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void close() throws ItemStreamException {
    }

    public void write(List<? extends T> items) throws Exception {
        BoundListOperations boundZSetOps = this.redisTemplate.boundListOps((Object)this.key);
        for (T t : items) {
            boundZSetOps.leftPush(t);
        }
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public String getIncrementKey() {
        return this.incrementKey;
    }

    public void setIncrementKey(String incrementKey) {
        this.incrementKey = incrementKey;
    }
}

