/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.batch.item.stream.BussinessValidItemStream;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.CountDataContent;
import com.viontech.keliu.model.Gate;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="mallCountData2RedisWriter")
public class MallCountData2RedisWriter
extends BussinessValidItemStream<CountDataContent>
implements ItemStreamWriter<CountDataContent> {
    private Logger logger = LoggerFactory.getLogger(MallCountData2RedisWriter.class);
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private OrgCacheService orgCacheService;
    @Value(value="${vion.time-offset.mall-day:0}")
    private int mallDayTimeOffset;

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        super.open(executionContext);
        this.updateExecutionContext();
    }

    private void updateExecutionContext() {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
        Map gate2MallMap = this.orgCacheService.getGate2MallMap();
        executionContext.put("gate2MallMap", (Object)gate2MallMap);
        Map gateMap = this.orgCacheService.getGateMap();
        executionContext.put("gateMap", (Object)gateMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        this.updateExecutionContext();
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("channelMap");
        executionContext.remove("gate2MallMap");
        executionContext.remove("gateMap");
        super.close();
    }

    protected Date getCounttime(CountDataContent countDataContent) {
        return countDataContent.getCountdate();
    }

    protected Long getMallId(CountDataContent countDataContent) {
        return countDataContent.getMallId();
    }

    public void write(List<? extends CountDataContent> items) throws Exception {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map channelMap = (Map)executionContext.get("channelMap");
        Map gate2MallMap = (Map)executionContext.get("gate2MallMap");
        Map gateMap = (Map)executionContext.get("gateMap");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        for (CountDataContent countDataContent : items) {
            Gate gate;
            Long mallId;
            Channel channel = (Channel)channelMap.get(countDataContent.getChannelno());
            if (channel == null || channel.getType() != null && channel.getType() == 1 && (countDataContent.getStatus() == null || countDataContent.getStatus() != 1) || channel.getGateId() == null || (mallId = (Long)gate2MallMap.get(String.valueOf(channel.getGateId()))) == null) continue;
            countDataContent.setMallId(mallId);
            if (!this.isValid((Object)countDataContent) || (gate = (Gate)gateMap.get(String.valueOf(channel.getGateId()))) == null) continue;
            Date counttime = countDataContent.getCreateTime();
            String dateStr = sdf.format(counttime);
            String dayDateStr = sdf.format(DateUtil.addHours((Date)counttime, (int)this.mallDayTimeOffset));
            dayDateStr = dayDateStr.substring(0, 8);
            Date countDate = counttime;
            countDate = DateUtil.setMilliseconds((Date)countDate, (int)0);
            countDate = DateUtil.setSeconds((Date)countDate, (int)0);
            Date minuteCountDate = DateUtil.setMinutes((Date)countDate, (int)(DateUtil.getMinute((Date)countDate) / 10 * 10));
            Date hourCountDate = DateUtil.setMinutes((Date)countDate, (int)0);
            StringBuilder sb = new StringBuilder();
            sb.append("countData:minute:mall:");
            sb.append(dateStr.substring(0, 11));
            String minueKeyPrefix = sb.toString();
            sb.setLength(0);
            sb.append("countData:hour:mall:");
            sb.append(dateStr.substring(0, 10));
            String hourKeyPrefix = sb.toString();
            sb.setLength(0);
            sb.append("countData:day:mall:");
            sb.append(dayDateStr);
            String dayKeyPrefix = sb.toString();
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            map.put("mallId", mallId);
            map.put("accountId", channel.getAccountId());
            sb.setLength(0);
            sb.append(minueKeyPrefix);
            sb.append(":");
            sb.append(mallId.intValue());
            String key = sb.toString();
            BoundHashOperations boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            this.incrementValue(countDataContent, gate.getType(), boundHashOps);
            map.put("createTime", minuteCountDate);
            boundHashOps.putAll(map);
            sb.setLength(0);
            sb.append(hourKeyPrefix);
            sb.append(":");
            sb.append(mallId.intValue());
            key = sb.toString();
            boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            this.incrementValue(countDataContent, gate.getType(), boundHashOps);
            map.put("createTime", hourCountDate);
            boundHashOps.putAll(map);
            sb.setLength(0);
            sb.append(dayKeyPrefix);
            Date dayCountDate = DateUtil.parse((String)"yyyyMMdd", (String)dayDateStr);
            sb.append(":");
            sb.append(mallId.intValue());
            key = sb.toString();
            boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            this.incrementValue(countDataContent, gate.getType(), boundHashOps);
            map.put("createTime", dayCountDate);
            boundHashOps.putAll(map);
        }
    }

    private void incrementValue(CountDataContent item, int type, BoundHashOperations boundHashOps) {
        if (type == 2) {
            boundHashOps.increment((Object)"outsideInum", (long)item.getInnum());
            boundHashOps.increment((Object)"outsideOutnum", (long)item.getOutnum());
        } else {
            boundHashOps.increment((Object)"innum", (long)item.getInnum());
            boundHashOps.increment((Object)"outnum", (long)item.getOutnum());
        }
    }
}

