/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.batch.item.stream.BussinessValidItemStream;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.CountDataContent;
import com.viontech.keliu.model.FloorGate;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="floorCountData2RedisWriter")
public class FloorCountData2RedisWriter
extends BussinessValidItemStream<CountDataContent>
implements ItemStreamWriter<CountDataContent> {
    private final Logger logger = LoggerFactory.getLogger(FloorCountData2RedisWriter.class);
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private OrgCacheService orgCacheService;
    @Value(value="${vion.time-offset.mall-day:0}")
    private int mallDayTimeOffset;

    private void updateExecutionContext() {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
        Map gate2ZoneMap = this.orgCacheService.getGate2FloorMap();
        executionContext.put("gate2FloorMap", (Object)gate2ZoneMap);
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        super.open(executionContext);
        this.updateExecutionContext();
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        this.updateExecutionContext();
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("channelMap");
        executionContext.remove("gate2FloorMap");
        super.close();
    }

    protected Date getCounttime(CountDataContent countDataContent) {
        return countDataContent.getCountdate();
    }

    protected Long getMallId(CountDataContent countDataContent) {
        return countDataContent.getMallId();
    }

    public void write(List<? extends CountDataContent> items) throws Exception {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map channelMap = (Map)executionContext.get("channelMap");
        Map floor2ZoneMap = (Map)executionContext.get("gate2FloorMap");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        for (CountDataContent countDataContent : items) {
            List list;
            Channel channel = (Channel)channelMap.get(countDataContent.getChannelno());
            if (channel == null) continue;
            Long mallId = channel.getMallId();
            countDataContent.setMallId(mallId);
            if (!this.isValid((Object)countDataContent) || channel.getType() != null && channel.getType() == 1 && (countDataContent.getStatus() == null || countDataContent.getStatus() != 1) || (list = (List)floor2ZoneMap.get(String.valueOf(channel.getGateId()))) == null || list.size() <= 0) continue;
            Date counttime = countDataContent.getCreateTime();
            String dateStr = sdf.format(counttime);
            String dayDateStr = sdf.format(DateUtil.addHours((Date)counttime, (int)this.mallDayTimeOffset));
            dayDateStr = dayDateStr.substring(0, 8);
            StringBuilder sb = new StringBuilder();
            sb.append("countData:minute:floor:");
            sb.append(dateStr.substring(0, 11));
            String minueKeyPrefix = sb.toString();
            sb.setLength(0);
            sb.append("countData:hour:floor:");
            sb.append(dateStr.substring(0, 10));
            String hourKeyPrefix = sb.toString();
            sb.setLength(0);
            sb.append("countData:day:floor:");
            sb.append(dayDateStr);
            String dayKeyPrefix = sb.toString();
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            Date countDate = countDataContent.getCreateTime();
            countDate = DateUtil.setMilliseconds((Date)countDate, (int)0);
            countDate = DateUtil.setSeconds((Date)countDate, (int)0);
            Date minuteCountDate = DateUtil.setMinutes((Date)countDate, (int)(DateUtil.getMinute((Date)countDate) / 10 * 10));
            Date hourCountDate = DateUtil.setMinutes((Date)countDate, (int)0);
            for (FloorGate floorGate : list) {
                map.clear();
                long floorId = floorGate.getFloorId();
                int type = floorGate.getType();
                map.put("mallId", channel.getMallId());
                map.put("accountId", channel.getAccountId());
                map.put("floorId", Long.valueOf(floorId));
                sb.setLength(0);
                sb.append(minueKeyPrefix);
                sb.append(":");
                sb.append(floorId);
                String key = sb.toString();
                BoundHashOperations boundHashOps = this.redisTemplate.boundHashOps((Object)key);
                map.put("createTime", minuteCountDate);
                this.incrementValue(countDataContent, type, boundHashOps);
                boundHashOps.putAll(map);
                sb.setLength(0);
                sb.append(hourKeyPrefix);
                sb.append(":");
                sb.append(floorId);
                key = sb.toString();
                boundHashOps = this.redisTemplate.boundHashOps((Object)key);
                map.put("createTime", hourCountDate);
                this.incrementValue(countDataContent, type, boundHashOps);
                boundHashOps.putAll(map);
                sb.setLength(0);
                sb.append(dayKeyPrefix);
                Date dayCountDate = DateUtil.parse((String)"yyyyMMdd", (String)dayDateStr);
                sb.append(":");
                sb.append(floorId);
                key = sb.toString();
                boundHashOps = this.redisTemplate.boundHashOps((Object)key);
                map.put("createTime", dayCountDate);
                this.incrementValue(countDataContent, type, boundHashOps);
                boundHashOps.putAll(map);
            }
        }
    }

    private void incrementValue(CountDataContent item, int type, BoundHashOperations boundHashOps) {
        if (type == 3) {
            boundHashOps.increment((Object)"outsideInum", (long)item.getInnum());
            boundHashOps.increment((Object)"outsideOutnum", (long)item.getOutnum());
        } else if (type == 1) {
            boundHashOps.increment((Object)"innum", (long)item.getInnum());
            boundHashOps.increment((Object)"outnum", (long)item.getOutnum());
        } else if (type == 2) {
            boundHashOps.increment((Object)"innum", (long)item.getOutnum());
            boundHashOps.increment((Object)"outnum", (long)item.getInnum());
        }
    }
}

