/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.batch.item.writer.FaceDataSta2RedisWriter;
import com.viontech.keliu.model.FaceDataContent;
import com.viontech.keliu.model.FloorGate;
import com.viontech.keliu.model.Zone;
import com.viontech.keliu.model.ZoneGate;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

@Component(value="faceHourDataSta2RedisWriter")
public class FaceHourDataSta2RedisWriter
implements ItemStreamWriter<FaceDataContent> {
    private final Logger logger = LoggerFactory.getLogger(FaceDataSta2RedisWriter.class);
    private static final Object GATE_SYNC = new Object();
    private static final Object MALL_SYNC = new Object();
    private static final Object FLOOR_SYNC = new Object();
    private static final Object ZONE_SYNC = new Object();
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private OrgCacheService orgCacheService;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        this.updateExecutionContext();
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        this.updateExecutionContext();
    }

    private void updateExecutionContext() {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map gate2ZoneMap = this.orgCacheService.getGate2ZoneMap();
        executionContext.put("gate2ZoneMap", (Object)gate2ZoneMap);
        Map gate2FloorMap = this.orgCacheService.getGate2FloorMap();
        executionContext.put("gate2FloorMap", (Object)gate2FloorMap);
        Map gate2MallMap = this.orgCacheService.getGate2MallMap();
        executionContext.put("gate2MallMap", (Object)gate2MallMap);
        Map zoneMap = this.orgCacheService.getZoneMap();
        executionContext.put("zoneMap", (Object)zoneMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("gate2ZoneMap");
        executionContext.remove("gate2FloorMap");
        executionContext.remove("gate2MallMap");
        executionContext.remove("zoneMap");
        this.executionContextThreadLocal.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<? extends FaceDataContent> items) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHH");
        SimpleDateFormat sdfH = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map gate2ZoneMap = (Map)executionContext.get("gate2ZoneMap");
        Map zoneMap = (Map)executionContext.get("zoneMap");
        Map gate2MallMap = (Map)executionContext.get("gate2MallMap");
        Map floor2ZoneMap = (Map)executionContext.get("gate2FloorMap");
        for (FaceDataContent faceDataContent : items) {
            List zoneGates;
            List floorGates;
            Object object;
            String personUnidKey;
            if (faceDataContent.getDirection() != 1) {
                this.logger.debug("\u65b9\u5411\u4e0d\u662f\u8fdb,\u8df3\u8fc7");
                continue;
            }
            Long gateId = faceDataContent.getGateId();
            if (gateId == null) {
                this.logger.warn("\u8bbe\u5907{}\u6ca1\u6709\u7ed1\u5b9a\u76d1\u63a7\u70b9", (Object)faceDataContent.getChannelSerialnum());
                continue;
            }
            Date counttime = sdfH.parse(faceDataContent.getStartTime());
            String dateStr = sdf.format(counttime);
            Long mallId = faceDataContent.getMallId();
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            map.put("mallId", faceDataContent.getMallId());
            map.put("accountId", faceDataContent.getAccountId());
            map.put("countDate", faceDataContent.getCountDate());
            map.put("gateId", gateId);
            map.put("countTime", counttime);
            StringBuilder sb = new StringBuilder();
            sb.append("faceSta:hour:gate:").append(dateStr).append(":").append(gateId);
            StringBuilder personSb = new StringBuilder();
            personSb.append("personUnid:hour:gate:").append(dateStr).append(":").append(gateId);
            String faceSta = sb.toString();
            BoundHashOperations boundHashOps = this.redisTemplate.boundHashOps((Object)faceSta);
            if (!this.redisTemplate.expire((Object)faceSta, 6L, TimeUnit.HOURS).booleanValue()) {
                Object object2 = GATE_SYNC;
                synchronized (object2) {
                    if (!this.redisTemplate.hasKey((Object)faceSta).booleanValue()) {
                        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u76d1\u63a7\u70b9> <\u5c0f\u65f6\u7ea7> \u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)faceSta);
                        this.loadGateHourFaceSta(gateId, counttime, boundHashOps);
                    }
                }
            }
            if (!this.redisTemplate.expire((Object)(personUnidKey = personSb.toString()), 6L, TimeUnit.HOURS).booleanValue()) {
                object = GATE_SYNC;
                synchronized (object) {
                    if (!this.redisTemplate.hasKey((Object)personUnidKey).booleanValue()) {
                        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u76d1\u63a7\u70b9> <\u5c0f\u65f6\u7ea7> personUnid key:{}", (Object)personUnidKey);
                        this.loadGateHourPersonUnid(personUnidKey, gateId, counttime);
                    }
                }
            }
            this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(personUnidKey, faceDataContent.getPersonId()));
            boundHashOps.putAll(map);
            if (gate2MallMap.containsKey(String.valueOf(gateId))) {
                sb.setLength(0);
                sb.append("faceSta:hour:mall:").append(dateStr).append(":").append(mallId);
                faceSta = sb.toString();
                boundHashOps = this.redisTemplate.boundHashOps((Object)faceSta);
                if (!this.redisTemplate.expire((Object)faceSta, 6L, TimeUnit.HOURS).booleanValue()) {
                    object = MALL_SYNC;
                    synchronized (object) {
                        if (!this.redisTemplate.hasKey((Object)faceSta).booleanValue()) {
                            this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u5546\u573a> <\u5c0f\u65f6\u7ea7> \u7edf\u8ba1\u7f13\u5b58 key:", (Object)faceSta);
                            this.loadMallHourFaceSta(mallId, counttime, boundHashOps);
                        }
                    }
                }
                personSb.setLength(0);
                personSb.append("personUnid:hour:mall:").append(dateStr).append(":").append(mallId);
                personUnidKey = personSb.toString();
                if (!this.redisTemplate.expire((Object)personUnidKey, 6L, TimeUnit.HOURS).booleanValue()) {
                    object = MALL_SYNC;
                    synchronized (object) {
                        if (!this.redisTemplate.hasKey((Object)personUnidKey).booleanValue()) {
                            this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u5546\u573a> <\u5c0f\u65f6\u7ea7> personUnid key:{}", (Object)personUnidKey);
                            this.loadMallHourPersonUnid(personUnidKey, mallId, counttime);
                        }
                    }
                }
                this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(personUnidKey, faceDataContent.getPersonId()));
                boundHashOps.putAll(map);
            }
            if ((floorGates = (List)floor2ZoneMap.get(String.valueOf(gateId))) != null && floorGates.size() > 0) {
                for (FloorGate floorGate : floorGates) {
                    Object object3;
                    int type = floorGate.getType();
                    if (type != 1) continue;
                    long floorId = floorGate.getFloorId();
                    map.put("floorId", Long.valueOf(floorId));
                    sb.setLength(0);
                    sb.append("faceSta:hour:floor:").append(dateStr).append(":").append(floorId);
                    faceSta = sb.toString();
                    boundHashOps = this.redisTemplate.boundHashOps((Object)faceSta);
                    if (!this.redisTemplate.expire((Object)faceSta, 6L, TimeUnit.HOURS).booleanValue()) {
                        object3 = FLOOR_SYNC;
                        synchronized (object3) {
                            if (!this.redisTemplate.hasKey((Object)faceSta).booleanValue()) {
                                this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u697c\u5c42> <\u5c0f\u65f6\u7ea7> \u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)faceSta);
                                this.loadFloorHourFaceSta(floorId, counttime, boundHashOps);
                            }
                        }
                    }
                    personSb.setLength(0);
                    personSb.append("personUnid:hour:floor:").append(dateStr).append(":").append(floorId);
                    personUnidKey = personSb.toString();
                    if (!this.redisTemplate.expire((Object)personUnidKey, 6L, TimeUnit.HOURS).booleanValue()) {
                        object3 = FLOOR_SYNC;
                        synchronized (object3) {
                            if (!this.redisTemplate.hasKey((Object)personUnidKey).booleanValue()) {
                                this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u697c\u5c42> <\u5c0f\u65f6\u7ea7> personUnid key:{}", (Object)personUnidKey);
                                this.loadFloorHourPersonUnid(personUnidKey, floorId, counttime);
                            }
                        }
                    }
                    this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(personUnidKey, faceDataContent.getPersonId()));
                    boundHashOps.putAll(map);
                }
            }
            if ((zoneGates = (List)gate2ZoneMap.get(String.valueOf(gateId))) == null || zoneGates.size() <= 0) continue;
            for (ZoneGate zoneGate : zoneGates) {
                Object object4;
                int type = zoneGate.getType();
                if (type != 1) continue;
                long zoneId = zoneGate.getZoneId();
                map.put("zoneId", Long.valueOf(zoneId));
                Zone zone = (Zone)zoneMap.get(String.valueOf(zoneId));
                if (zone == null) {
                    this.logger.info("zoneId {} null , zoneMap size is {}", (Object)zoneId, (Object)zoneMap.size());
                } else {
                    map.put("floorId", Long.valueOf(zone.getFloorId()));
                }
                sb.setLength(0);
                sb.append("faceSta:hour:zone:").append(dateStr).append(":").append(zoneId);
                faceSta = sb.toString();
                boundHashOps = this.redisTemplate.boundHashOps((Object)faceSta);
                if (!this.redisTemplate.expire((Object)faceSta, 6L, TimeUnit.HOURS).booleanValue()) {
                    object4 = ZONE_SYNC;
                    synchronized (object4) {
                        if (!this.redisTemplate.hasKey((Object)faceSta).booleanValue()) {
                            this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u533a\u57df> <\u5c0f\u65f6\u7ea7> \u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)faceSta);
                            this.loadZoneHourFaceSta(zoneId, counttime, boundHashOps);
                        }
                    }
                }
                personSb.setLength(0);
                personSb.append("personUnid:hour:zone:").append(dateStr).append(":").append(zoneId);
                personUnidKey = personSb.toString();
                if (!this.redisTemplate.expire((Object)personUnidKey, 6L, TimeUnit.HOURS).booleanValue()) {
                    object4 = ZONE_SYNC;
                    synchronized (object4) {
                        if (!this.redisTemplate.hasKey((Object)personUnidKey).booleanValue()) {
                            this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u533a\u57df> <\u5c0f\u65f6\u7ea7> personUnid key:{}", (Object)personUnidKey);
                            this.loadZoneHourPersonUnid(personUnidKey, zoneId, counttime);
                        }
                    }
                }
                this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(personUnidKey, faceDataContent.getPersonId()));
                boundHashOps.putAll(map);
            }
        }
    }

    private void loadZoneHourPersonUnid(String key, long zoneId, Date counttime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH");
        String dateStr = sdf.format(counttime);
        Date date = sdf.parse(dateStr);
        List list = this.jdbcTemplate.queryForList("SELECT person_unid FROM d_face_recognition WHERE countdate = ? and gate_id IN (SELECT gate_id FROM r_zone_gate WHERE r_zone_gate.zone_id=?) AND counttime >= ? AND counttime < ? ", new Object[]{date, zoneId, date, DateUtil.addHours((Date)date, (int)1)}, String.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.redisTemplate.boundSetOps((Object)key).add(list.toArray());
        this.redisTemplate.expire((Object)key, 6L, TimeUnit.HOURS);
    }

    private void loadFloorHourPersonUnid(String key, long floorId, Date counttime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH");
        String dateStr = sdf.format(counttime);
        Date date = sdf.parse(dateStr);
        List list = this.jdbcTemplate.queryForList("SELECT person_unid FROM d_face_recognition WHERE countdate = ? and gate_id IN (SELECT gate_id FROM r_floor_gate WHERE r_floor_gate.floor_id=?) AND counttime >= ? AND counttime <? ", new Object[]{date, floorId, date, DateUtil.addHours((Date)date, (int)1)}, String.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.redisTemplate.boundSetOps((Object)key).add(list.toArray());
        this.redisTemplate.expire((Object)key, 6L, TimeUnit.HOURS);
    }

    private void loadMallHourPersonUnid(String key, Long mallId, Date counttime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH");
        String dateStr = sdf.format(counttime);
        Date date = sdf.parse(dateStr);
        List list = this.jdbcTemplate.queryForList("SELECT person_unid FROM d_face_recognition WHERE countdate = ? AND mall_id=? and  counttime >=? and counttime < ? ", new Object[]{date, mallId, date, DateUtil.addHours((Date)date, (int)1)}, String.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.redisTemplate.boundSetOps((Object)key).add(list.toArray());
        this.redisTemplate.expire((Object)key, 6L, TimeUnit.HOURS);
    }

    private void loadGateHourPersonUnid(String key, Long gateId, Date counttime) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH");
        String dateStr = sdf.format(counttime);
        Date date = sdf.parse(dateStr);
        List list = this.jdbcTemplate.queryForList("SELECT person_unid FROM d_face_recognition WHERE countdate = ? and gate_id = ? AND counttime >= ? AND counttime < ? ", new Object[]{date, gateId, date, DateUtil.addHours((Date)date, (int)1)}, String.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.redisTemplate.boundSetOps((Object)key).add(list.toArray());
        this.redisTemplate.expire((Object)key, 6L, TimeUnit.HOURS);
    }

    private void loadZoneHourFaceSta(long zoneId, Date counttime, BoundHashOperations boundHashOps) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH");
        String dateStr = sdf.format(counttime);
        Date date = sdf.parse(dateStr);
        this.jdbcTemplate.query("SELECT * FROM d_zone_hour_face_recognition_sta WHERE countdate = ? and counttime=? AND zone_id=? LIMIT 1", new Object[]{date, date, zoneId}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadFloorHourFaceSta(long floorId, Date counttime, BoundHashOperations boundHashOps) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH");
        String dateStr = sdf.format(counttime);
        Date date = sdf.parse(dateStr);
        this.jdbcTemplate.query("SELECT * FROM d_floor_hour_face_recognition_sta WHERE  countdate = ? and  counttime=? AND floor_id=? LIMIT 1", new Object[]{date, date, floorId}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadMallHourFaceSta(Long mallId, Date counttime, BoundHashOperations boundHashOps) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH");
        String dateStr = sdf.format(counttime);
        Date date = sdf.parse(dateStr);
        this.jdbcTemplate.query("SELECT * FROM d_mall_hour_face_recognition_sta WHERE  countdate = ? and counttime=? AND mall_id=? LIMIT 1", new Object[]{date, date, mallId}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadGateHourFaceSta(Long gateId, Date counttime, BoundHashOperations boundHashOps) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH");
        String dateStr = sdf.format(counttime);
        Date date = sdf.parse(dateStr);
        this.jdbcTemplate.query("SELECT * FROM d_gate_hour_face_recognition_sta WHERE  countdate = ? and counttime=? AND gate_id=? LIMIT 1", new Object[]{date, date, gateId}, this.getRowCallbackHandler(boundHashOps));
    }

    private RowCallbackHandler getRowCallbackHandler(BoundHashOperations boundHashOps) {
        return rs -> {
            int count;
            int i;
            boundHashOps.increment((Object)"personMantime", (long)rs.getInt("person_mantime"));
            boundHashOps.increment((Object)"personCount", (long)rs.getInt("person_count"));
            boundHashOps.increment((Object)"customMantime", (long)rs.getInt("custom_mantime"));
            boundHashOps.increment((Object)"customCount", (long)rs.getInt("custom_count"));
            boundHashOps.increment((Object)"staffCount", (long)rs.getInt("staff_count"));
            boundHashOps.increment((Object)"staffMantime", (long)rs.getInt("staff_mantime"));
            boundHashOps.increment((Object)"maleMantime", (long)rs.getInt("male_mantime"));
            boundHashOps.increment((Object)"maleCount", (long)rs.getInt("male_count"));
            boundHashOps.increment((Object)"femaleMantime", (long)rs.getInt("female_mantime"));
            boundHashOps.increment((Object)"femaleCount", (long)rs.getInt("female_count"));
            String[] maleStage = rs.getString("male_stage").split(",");
            String[] femaleStage = rs.getString("female_stage").split(",");
            for (i = 0; i < maleStage.length; ++i) {
                count = Integer.parseInt(maleStage[i].trim());
                if (count <= 0) continue;
                boundHashOps.increment((Object)("maleDetail" + i), (long)count);
            }
            for (i = 0; i < femaleStage.length; ++i) {
                count = Integer.parseInt(femaleStage[i].trim());
                if (count <= 0) continue;
                boundHashOps.increment((Object)("femaleDetail" + i), (long)count);
            }
        };
    }

    private boolean isRepeatPersonUnid(String key, String personUnid) {
        long member = this.redisTemplate.boundSetOps((Object)key).add(new Object[]{personUnid});
        if (this.redisTemplate.getExpire((Object)key) == -1L) {
            this.redisTemplate.expire((Object)key, 5L, TimeUnit.DAYS);
        }
        return member <= 0L;
    }

    private void incrementValue(BoundHashOperations boundHashOps, FaceDataContent faceDataContent, boolean repeatPersonUnid) {
        this.logger.debug("\u5f00\u59cb\u7d2f\u52a0\u6570\u636e:{}", boundHashOps.getKey());
        boolean infoValidData = false;
        if (faceDataContent.getGender() >= 0 && faceDataContent.getAge() >= 0) {
            infoValidData = true;
        }
        String genderStr = faceDataContent.getGender() == 1 ? "male" : "female";
        String infoKey = genderStr + "Detail" + faceDataContent.getAge();
        boundHashOps.increment((Object)"personMantime", 1L);
        if (faceDataContent.getPersonType() == null || faceDataContent.getPersonType() != 1) {
            if (infoValidData) {
                String manTimeKey = genderStr + "Mantime";
                boundHashOps.increment((Object)manTimeKey, 1L);
            }
            boundHashOps.increment((Object)"customMantime", 1L);
        } else {
            boundHashOps.increment((Object)"staffMantime", 1L);
        }
        boundHashOps.expire(6L, TimeUnit.HOURS);
        if (repeatPersonUnid) {
            return;
        }
        boundHashOps.increment((Object)"personCount", 1L);
        if (faceDataContent.getPersonType() == null || faceDataContent.getPersonType() != 1) {
            boundHashOps.increment((Object)"customCount", 1L);
            if (infoValidData) {
                String countKey = genderStr + "Count";
                boundHashOps.increment((Object)countKey, 1L);
                boundHashOps.increment((Object)infoKey, 1L);
            }
        } else {
            boundHashOps.increment((Object)"staffCount", 1L);
        }
    }
}

