/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.batch.item.writer.InsertOrUpdateItemWriter;
import com.viontech.keliu.dao.ChannelDao;
import com.viontech.keliu.dao.DeviceDao;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.Device;
import com.viontech.keliu.model.RegisterContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class ChannelJdbcBatchItemWriter
extends InsertOrUpdateItemWriter<Channel> {
    private DeviceDao deviceDao;
    private ChannelDao channelDao;
    private static final String SQL_INSERT = "INSERT INTO b_channel (serialnum, name, device_serialnum, device_id, mall_id, account_id,status) VALUES (:serialnum, :serialnum, :deviceSerialnum,:deviceId,:mallId,:accountId,1);";

    public ChannelJdbcBatchItemWriter(DataSource dataSource) {
        super(SQL_INSERT, null, dataSource);
    }

    public void write(List items) throws Exception {
        if (items.isEmpty()) {
            return;
        }
        for (Object object : items) {
            RegisterContent registerContent = (RegisterContent)object;
            Device device = this.deviceDao.selectBySerialnum(registerContent.getSerialNum());
            if (device == null) continue;
            int count = registerContent.getVaCount();
            ArrayList<Channel> channels = new ArrayList<Channel>();
            StringBuilder sb = new StringBuilder();
            if (count == 0) {
                count = 1;
            }
            for (int i = 0; i < count; ++i) {
                Channel channel;
                sb.setLength(0);
                Map channelTypeMap = registerContent.getChanneltype();
                Integer channelType = null;
                if (channelTypeMap != null) {
                    channelType = (Integer)channelTypeMap.get("channel" + (i + 1));
                }
                if (channelType != null && channelType == 405) {
                    channel = new Channel();
                    channel.setDeviceSerialnum(device.getSerialnum());
                    channel.setDeviceId(device.getId());
                    channel.setMallId(device.getMallId());
                    channel.setAccountId(device.getAccountId());
                    sb.append(device.getSerialnum()).append("-");
                    sb.append("02");
                    channel.setSerialnum(sb.toString());
                    channels.add(channel);
                    sb.setLength(0);
                    channel = new Channel();
                    channel.setDeviceSerialnum(device.getSerialnum());
                    channel.setDeviceId(device.getId());
                    channel.setMallId(device.getMallId());
                    channel.setAccountId(device.getAccountId());
                    sb.append(device.getSerialnum()).append("-");
                    sb.append("01");
                    channel.setSerialnum(sb.toString());
                    channels.add(channel);
                    continue;
                }
                channel = new Channel();
                channel.setDeviceSerialnum(device.getSerialnum());
                channel.setDeviceId(device.getId());
                channel.setMallId(device.getMallId());
                channel.setAccountId(device.getAccountId());
                sb.append(device.getSerialnum()).append("-");
                if (i < 9) {
                    sb.append("0");
                }
                sb.append(i + 1);
                channel.setSerialnum(sb.toString());
                channels.add(channel);
            }
            super.write(channels);
        }
    }

    public DeviceDao getDeviceDao() {
        return this.deviceDao;
    }

    public void setDeviceDao(DeviceDao deviceDao) {
        this.deviceDao = deviceDao;
    }

    public ChannelDao getChannelDao() {
        return this.channelDao;
    }

    public void setChannelDao(ChannelDao channelDao) {
        this.channelDao = channelDao;
    }

    protected boolean needInsert(Channel item) {
        return this.channelDao.selectBySerialnum(item.getSerialnum()) == null;
    }
}

