/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.reader;

import com.viontech.keliu.model.License;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisPopReader<T>
implements ItemReader<T> {
    private Logger logger = LoggerFactory.getLogger(RedisPopReader.class);
    private String key = null;
    private int popType = 1;
    public static final int POP_TYPE_RIGHT = 0;
    public static final int POP_TYPE_LEFT = 1;
    private RedisTemplate redisTemplate;
    public ReentrantLock lock = new ReentrantLock();
    public Condition notEmpty = this.lock.newCondition();
    public static final long DEFAULT_AWAIT_IN_MILLIS = 30000L;
    private long awaitInMillis = 0L;
    private int tryCount = 0;
    private long lastCommitTime = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T read() throws Exception {
        if (this.key == null) {
            throw new NoSuchElementException("key");
        }
        this.awaitInMillis = 30000L;
        this.tryCount = 0;
        while (true) {
            Object id = null;
            try {
                if (!License.isValid()) {
                    throw new RuntimeException("License\u5df2\u7ecf\u5931\u6548");
                }
                if (System.currentTimeMillis() - this.lastCommitTime > 60000L) {
                    this.lastCommitTime = System.currentTimeMillis();
                    return null;
                }
                id = 1 == this.popType ? this.redisTemplate.boundListOps((Object)this.key).leftPop(30000L, TimeUnit.MILLISECONDS) : this.redisTemplate.boundListOps((Object)this.key).rightPop(30000L, TimeUnit.MILLISECONDS);
                if (id != null) {
                    this.tryCount = 0;
                    this.awaitInMillis = 30000L;
                    return (T)id;
                }
                ++this.tryCount;
                if (this.tryCount > 10) {
                    this.lastCommitTime = System.currentTimeMillis();
                    return null;
                }
                this.awaitInMillis = 30000L;
                continue;
            }
            catch (Exception e) {
                this.logger.error("\u8bfb\u53d6" + this.key + "\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
                this.lock.lock();
                try {
                    if (this.awaitInMillis < 100000L) {
                        this.awaitInMillis += this.awaitInMillis;
                    } else {
                        this.lastCommitTime = System.currentTimeMillis();
                        T t = null;
                        return t;
                    }
                    this.notEmpty.await(this.awaitInMillis, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    continue;
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
            }
            break;
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

