/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.reader;

import com.viontech.keliu.model.License;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamReader;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisHashDataReader
implements ItemStreamReader<Map<String, Object>> {
    private String keyPattern = "";
    private RedisTemplate redisTemplate;
    private Logger logger = LoggerFactory.getLogger(RedisHashDataReader.class);
    private ThreadLocal<Set<String>> keysThreadLocal = new ThreadLocal();
    private boolean needDel = true;

    public RedisHashDataReader(RedisTemplate redisTemplate, String keyPattern) {
        this.keyPattern = keyPattern;
        this.redisTemplate = redisTemplate;
    }

    public Map read() throws Exception {
        if (!License.isValid()) {
            return null;
        }
        Set keys = (Set)this.keysThreadLocal.get();
        if (keys == null) {
            keys = this.redisTemplate.keys((Object)this.keyPattern);
            if (keys == null || keys.isEmpty()) {
                return null;
            }
            this.keysThreadLocal.set(keys);
        }
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String keyStr = (String)iterator.next();
            Map entries = null;
            try {
                DataType dataType = this.redisTemplate.type((Object)keyStr);
                if (dataType != DataType.HASH) continue;
                if (this.needDel) {
                    String processKey = keyStr;
                    if (!keyStr.contains("process")) {
                        processKey = keyStr + ":process";
                    }
                    this.redisTemplate.rename((Object)keyStr, (Object)processKey);
                    entries = this.redisTemplate.boundHashOps((Object)processKey).entries();
                    this.redisTemplate.delete((Object)processKey);
                } else {
                    entries = this.redisTemplate.boundHashOps((Object)keyStr).entries();
                }
                iterator.remove();
                return entries;
            }
            catch (Exception e) {
                this.logger.error("\u8bfb\u53d6" + keyStr + "\u5931\u8d25", (Throwable)e);
                e.printStackTrace();
            }
        }
        this.keysThreadLocal.remove();
        return null;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
    }

    public void close() throws ItemStreamException {
    }

    public String getKeyPattern() {
        return this.keyPattern;
    }

    public void setKeyPattern(String keyPattern) {
        this.keyPattern = keyPattern;
    }

    public void setDel(boolean needDel) {
        this.needDel = needDel;
    }
}

