/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.batch.item.processor.RawCountDataProcessor;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.MultiPCountRecordContent;
import com.viontech.keliu.model.Retention;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
public class HeatMapDataProcessor
implements ItemProcessor<MultiPCountRecordContent, Retention>,
ItemStream {
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();
    private Logger logger = LoggerFactory.getLogger(RawCountDataProcessor.class);
    @Autowired
    private OrgCacheService orgCacheService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private RedisTemplate redisTemplate;
    private static final Object retentionRawKeySync = new Object();

    public Retention process(MultiPCountRecordContent item) throws Exception {
        Map channelMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("channelMap");
        Channel channel = (Channel)channelMap.get(item.getChannelno());
        if (channel == null) {
            this.logger.warn("\u65e0\u6cd5\u67e5\u627e\u901a\u9053 \u8df3\u8fc7\u6570\u636e" + item.getChannelno());
            return null;
        }
        if (this.isRepeat(item)) {
            this.logger.warn("\u91cd\u590dretentionData\u6570\u636e");
            List retentionList = this.jdbcTemplate.query("select device_serialnum,channel_serialnum,gate_id,num,counttime,countdate from d_retention_raw where channel_serialnum = ? and countdate = ? and counttime = ?", new Object[]{item.getChannelno(), DateUtil.parse((String)DateUtil.FORMAT_SHORT, (String)DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)item.getCounttime())), item.getCounttime()}, (RowMapper)new BeanPropertyRowMapper(Retention.class));
            if (retentionList.isEmpty()) {
                this.logger.warn("\u672c\u6b21\u4e0a\u4f20\u7684\u91cd\u590d\u6570\u636e");
                return null;
            }
            Integer numDiff = item.getRecords().size() - ((Retention)retentionList.get(0)).getNum();
            if (numDiff == 0) {
                this.logger.warn("\u503c\u76f8\u540c\u7684\u91cd\u590d\u6570\u636e");
                return null;
            }
            ((Retention)retentionList.get(0)).setNum(Integer.valueOf(item.getRecords().size()));
            return (Retention)retentionList.get(0);
        }
        Retention retention = new Retention();
        retention.setDeviceSerialnum(channel.getDeviceSerialnum());
        retention.setChannelSerialnum(channel.getSerialnum());
        retention.setGateId(channel.getGateId());
        retention.setNum(Integer.valueOf(item.getRecords().size()));
        retention.setCounttime(item.getCounttime());
        retention.setMallId(channel.getMallId());
        retention.setAccountId(channel.getAccountId());
        List records = item.getRecords();
        if (records != null && records.size() > 0) {
            ArrayList<Retention.Record> retentionRecords = new ArrayList<Retention.Record>();
            for (MultiPCountRecordContent.Record record : records) {
                Retention.Record retentionRecord = new Retention.Record();
                retentionRecord.setCounttime(item.getCounttime());
                retentionRecord.setGateId(channel.getGateId());
                retentionRecord.setDeviceSerialnum(channel.getDeviceSerialnum());
                retentionRecord.setChannelSerialnum(channel.getSerialnum());
                retentionRecord.setX(record.getX());
                retentionRecord.setY(record.getY());
                retentionRecord.setFx(record.getFx());
                retentionRecord.setFy(record.getFy());
                retentionRecord.setRx(record.getRx());
                retentionRecord.setRy(record.getRy());
                retentionRecord.setScore(record.getScore());
                retentionRecord.setSize(record.getSize());
                retentionRecords.add(retentionRecord);
            }
            retention.setRecords(retentionRecords);
        }
        return retention;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRepeat(MultiPCountRecordContent item) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        SimpleDateFormat sdfkey = new SimpleDateFormat("yyyyMMdd");
        Date counttime = item.getCounttime();
        StringBuilder sb = new StringBuilder();
        sb.append(item.getChannelno());
        sb.append(":");
        sb.append(sdf.format(counttime));
        String key = sb.toString();
        String datestr = sdfkey.format(item.getCounttime());
        String retentionRawKey = "retentionRawKey:" + datestr;
        if (!this.redisTemplate.expire((Object)retentionRawKey, 2L, TimeUnit.DAYS).booleanValue()) {
            Object object = retentionRawKeySync;
            synchronized (object) {
                if (!this.redisTemplate.hasKey((Object)retentionRawKey).booleanValue()) {
                    List retentionList = this.jdbcTemplate.query("select channel_serialnum ,counttime from d_retention_raw where countdate = ?", new Object[]{DateUtil.parse((String)DateUtil.FORMAT_SHORT, (String)DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)item.getCounttime()))}, (RowMapper)new BeanPropertyRowMapper(Retention.class));
                    if (retentionList.isEmpty()) {
                        this.redisTemplate.boundSetOps((Object)retentionRawKey).add(new Object[]{key});
                        return false;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    for (Retention retention : retentionList) {
                        if (retention.getChannelSerialnum() == null && retention.getCounttime() == null) continue;
                        list.add(retention.getChannelSerialnum() + ":" + sdf.format(retention.getCounttime()));
                    }
                    this.redisTemplate.boundSetOps((Object)retentionRawKey).add((Object[])list.toArray(new String[0]));
                    this.redisTemplate.boundSetOps((Object)retentionRawKey).expire(2L, TimeUnit.DAYS);
                }
            }
        }
        return this.redisTemplate.boundSetOps((Object)retentionRawKey).add(new Object[]{key}) <= 0L;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
        Map gateMap = this.orgCacheService.getGateMap();
        executionContext.put("gateMap", (Object)gateMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
        Map gateMap = this.orgCacheService.getGateMap();
        executionContext.put("gateMap", (Object)gateMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("channelMap");
        executionContext.remove("gateMap");
        this.executionContextThreadLocal.remove();
    }
}

