/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.Retention;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component(value="gateRetentionDataProcessor")
public class GateRetentionDataProcessor
implements ItemProcessor<Retention, Retention>,
ItemStream {
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();
    private static final Object countDataRawKeySync = new Object();
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private OrgCacheService orgCacheService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private Logger logger = LoggerFactory.getLogger(GateRetentionDataProcessor.class);

    public Retention process(Retention item) throws Exception {
        this.logger.debug("\u5f00\u59cb\u76d1\u63a7\u70b9\u5ba2\u6d41\u662f\u5426\u9700\u8981\u7d2f\u52a0\u5224\u65ad");
        if (item.getCounttime() == null) {
            this.logger.warn("CountData\u6570\u636e\u6ca1\u6709\u7edf\u8ba1\u65f6\u95f4");
            return null;
        }
        if (item.getGateId() == null) {
            Map channelMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("channelMap");
            Channel channel = (Channel)channelMap.get(item.getChannelSerialnum());
            if (channel == null) {
                this.logger.warn("\u65e0\u6cd5\u67e5\u627e\u901a\u9053 \u8df3\u8fc7\u6570\u636e" + item.getChannelSerialnum());
                return null;
            }
            item.setGateId(channel.getGateId());
        }
        if (item.getGateId() == null) {
            return null;
        }
        item.setRepeat(false);
        if (this.isRepeat(item)) {
            item.setRepeat(true);
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRepeat(Retention item) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date counttime = item.getCounttime();
        StringBuilder sb = new StringBuilder();
        sb.append(item.getGateId());
        sb.append(":");
        sb.append(sdf.format(counttime));
        String key = sb.toString();
        String datestr = DateUtil.format((String)"yyyyMMdd", (Date)item.getCounttime());
        String countDataRawKey = "gateRetentionDataKey:" + datestr;
        if (!this.redisTemplate.expire((Object)countDataRawKey, 2L, TimeUnit.DAYS).booleanValue()) {
            Object object = countDataRawKeySync;
            synchronized (object) {
                if (!this.redisTemplate.hasKey((Object)countDataRawKey).booleanValue()) {
                    List gateRetentionListList = this.jdbcTemplate.query("select gate_id as gateId,counttime as counttime from d_gate_retention where  countdate = ?", new Object[]{item.getCounttime()}, (RowMapper)new BeanPropertyRowMapper(Retention.class));
                    if (gateRetentionListList.isEmpty()) {
                        this.redisTemplate.boundSetOps((Object)countDataRawKey).add((Object[])new String[]{key});
                        return false;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    for (Retention retention : gateRetentionListList) {
                        if (retention.getGateId() == null && retention.getCounttime() == null) continue;
                        list.add(retention.getGateId() + ":" + sdf.format(retention.getCounttime()));
                    }
                    this.redisTemplate.boundSetOps((Object)countDataRawKey).add((Object[])list.toArray(new String[0]));
                    this.redisTemplate.boundSetOps((Object)countDataRawKey).expire(2L, TimeUnit.DAYS);
                }
            }
        }
        return this.redisTemplate.boundSetOps((Object)countDataRawKey).add((Object[])new String[]{key}) <= 0L;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("channelMap");
    }
}

