/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.model.FloorCountData;
import com.viontech.keliu.util.DateUtil;
import java.util.Date;
import java.util.Map;
import org.springframework.batch.item.ItemProcessor;

public class FloorCountDataProcessor
implements ItemProcessor<Map, FloorCountData> {
    private int mallDayTimeOffset;

    public FloorCountDataProcessor(int mallDayTimeOffset) {
        this.mallDayTimeOffset = mallDayTimeOffset;
    }

    public FloorCountData process(Map item) throws Exception {
        Long floorId = (Long)item.get("floorId");
        if (floorId == null) {
            return null;
        }
        Long mallId = (Long)item.get("mallId");
        if (mallId == null) {
            return null;
        }
        Long accountId = (Long)item.get("accountId");
        if (accountId == null) {
            return null;
        }
        Integer innum = 0;
        try {
            innum = Integer.parseInt(item.get("innum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer outnum = 0;
        try {
            outnum = Integer.parseInt(item.get("outnum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date createTime = (Date)item.get("createTime");
        if (createTime == null) {
            return null;
        }
        FloorCountData floorCountData = new FloorCountData();
        floorCountData.setInnum(innum.intValue());
        floorCountData.setOutnum(outnum.intValue());
        floorCountData.setAccountId(accountId.longValue());
        floorCountData.setMallId(mallId.longValue());
        floorCountData.setFloorId(floorId.longValue());
        floorCountData.setCountDate(DateUtil.addHours((Date)createTime, (int)this.mallDayTimeOffset));
        floorCountData.setCountTime(createTime);
        return floorCountData;
    }
}

