/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.model.CountDataContent;
import com.viontech.keliu.model.FaceDataContent;
import com.viontech.keliu.model.Gate;
import com.viontech.keliu.redis.RedisUtil;
import com.viontech.keliu.service.OrgCacheService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dataFilterProcessor")
public class DataFilterProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(DataFilterProcessor.class);
    @Autowired
    private OrgCacheService orgCacheService;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();

    public FaceDataContent process(FaceDataContent item) {
        Gate gate;
        Map gateMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("gateMap");
        if (gateMap != null && !gateMap.isEmpty() && (gate = (Gate)gateMap.get(String.valueOf(item.getGateId()))) != null && gate.getType() == 5) {
            return item;
        }
        CountDataContent cdc = new CountDataContent();
        cdc.setVasid(item.getVasId());
        cdc.setInnum(0);
        cdc.setOutnum(0);
        if (item.getDirection() == 1) {
            cdc.setInnum(1);
        } else if (item.getDirection() == -1) {
            cdc.setOutnum(1);
        }
        cdc.setChannelno(item.getChannelSerialnum());
        cdc.setCreateTime(item.getCountDate());
        cdc.setStatus(Integer.valueOf(1));
        RedisUtil.addList((String)"countData", (Object)cdc);
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map gateMap = this.orgCacheService.getGateMap();
        executionContext.put("gateMap", (Object)gateMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map gateMap = this.orgCacheService.getGateMap();
        executionContext.put("gateMap", (Object)gateMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("gateMap");
        this.executionContextThreadLocal.remove();
    }
}

