/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.batch.configuration.RawCountDataJobConfiguration;
import com.viontech.keliu.batch.item.processor.CompositeItemStreamProcessor;
import com.viontech.keliu.batch.item.processor.CountDataValidProcessor;
import com.viontech.keliu.batch.item.processor.RawCountDataProcessor;
import com.viontech.keliu.batch.item.reader.RedisPopReader;
import com.viontech.keliu.batch.item.writer.FloorCountData2RedisWriter;
import com.viontech.keliu.batch.item.writer.GateCountData2RedisWriter;
import com.viontech.keliu.batch.item.writer.MallCountData2RedisWriter;
import com.viontech.keliu.batch.item.writer.ZoneCountData2RedisWriter;
import com.viontech.keliu.batch.listener.ExecutionContextClearListener;
import com.viontech.keliu.batch.listener.JobRestartListener;
import com.viontech.keliu.batch.listener.StepLoggerListener;
import com.viontech.keliu.model.CountDataContent;
import com.viontech.keliu.service.OrgCacheService;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.support.CompositeItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class RawCountDataJobConfiguration {
    private Logger logger = LoggerFactory.getLogger(RawCountDataJobConfiguration.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private OrgCacheService orgCacheService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Value(value="${spring.batch.job.chunkSize:1}")
    private int chunkSize;

    @Bean(name={"rawCountDataProcessJob"})
    public Job rawCountDataProcessJob(JobRepository jobRepository, Step rawCountDataStep, JobRestartListener jobRestartListener) {
        return ((JobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("rawCountDataProcessJob").listener((JobExecutionListener)jobRestartListener)).incrementer((JobParametersIncrementer)new RunIdIncrementer())).repository(jobRepository)).start(rawCountDataStep).build();
    }

    @Bean(name={"rawCountDataStep"})
    public Step rawCountDataStep(PlatformTransactionManager transactionManager, TaskExecutor taskExecutor, ItemReader<CountDataContent> rawCountDataReader4Redis, ItemWriter countDataCompositeWriter, ItemProcessor<CountDataContent, CountDataContent> rawCountDataCompositeProcessor) {
        RepeatTemplate stepOperations = new RepeatTemplate();
        stepOperations.setCompletionPolicy((CompletionPolicy)new /* Unavailable Anonymous Inner Class!! */);
        TaskletStep step = ((StepBuilder)((StepBuilder)this.stepBuilderFactory.get("rawCountDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).listener((StepExecutionListener)new StepLoggerListener())).chunk(this.chunkSize).reader(rawCountDataReader4Redis).processor(rawCountDataCompositeProcessor).writer(countDataCompositeWriter).stepOperations((RepeatOperations)stepOperations).build();
        return step;
    }

    @Bean(value={"rawCountDataCompositeProcessor"})
    public ItemProcessor<CountDataContent, CountDataContent> countDataCompositeProcessor(CountDataValidProcessor countDataValidProcessor, RawCountDataProcessor rawCountDataProcessor) {
        ArrayList<Object> delegates = new ArrayList<Object>();
        delegates.add(countDataValidProcessor);
        delegates.add(rawCountDataProcessor);
        CompositeItemStreamProcessor countDataCompositeProcessor = new CompositeItemStreamProcessor();
        countDataCompositeProcessor.setDelegates(delegates);
        return countDataCompositeProcessor;
    }

    @Bean(value={"rawCountDataReader4Redis"})
    public ItemReader rawCountDataReader4Redis(RedisTemplate redisTemplate) {
        RedisPopReader redisPopReader = new RedisPopReader();
        redisPopReader.setRedisTemplate(redisTemplate);
        redisPopReader.setKey("countData");
        return redisPopReader;
    }

    @Bean(name={"countDataCompositeWriter"})
    public ItemWriter countDataCompositeWriter(ItemWriter rawCountData2DBWriter, GateCountData2RedisWriter gateCountData2RedisWriter, ZoneCountData2RedisWriter zoneCountData2RedisWriter, FloorCountData2RedisWriter floorCountData2RedisWriter, MallCountData2RedisWriter mallCountData2RedisWriter) {
        CompositeItemWriter compositeItemWriter = new CompositeItemWriter();
        ArrayList<Object> delegates = new ArrayList<Object>();
        delegates.add(rawCountData2DBWriter);
        delegates.add(gateCountData2RedisWriter);
        delegates.add(zoneCountData2RedisWriter);
        delegates.add(floorCountData2RedisWriter);
        delegates.add(mallCountData2RedisWriter);
        compositeItemWriter.setDelegates(delegates);
        return compositeItemWriter;
    }

    @Bean(name={"rawCountData2DBWriter"})
    public ItemWriter rawCountData2DBWriter(DataSource dataSource) {
        String insertsql = "INSERT INTO d_count_data (device_serialnum, channel_serialnum, innum, outnum, counttime, countdate, status, gate_id) VALUES (:vasid,:channelno, :innum, :outnum, :createTime,:countdate,:status,:gateId)";
        String updatesql = "update d_count_data set innum=innum+:innum, outnum=outnum+:outnum where channel_serialnum =:channelno and counttime=:createTime and countdate=:countdate";
        2 writer = new /* Unavailable Anonymous Inner Class!! */;
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }
}

