/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.util;

public class FisheyeMappingUtil {
    private double[] ss = new double[this.ss_len];
    private int ss_len = 5;
    private double cameraCenterX = 0.0;
    private double cameraCenterY = 0.0;
    private double cameraInstallX = 0.0;
    private double cameraInstallY = 0.0;
    private double cameraInstallHeight = 0.0;
    private double cameraInstallAngle = 0.0;
    private double c = 0.0;
    private double d = 0.0;
    private double e = 0.0;

    private FisheyeMappingUtil() {
        this.ss[0] = -294.5521;
        this.ss[1] = 0.0;
        this.ss[2] = 0.00140344;
        this.ss[3] = -1.577433E-6;
        this.ss[4] = 4.228309E-9;
        this.cameraCenterX = 641.7795;
        this.cameraCenterY = 473.1909;
        this.c = 0.9997644;
        this.d = 0.0020472;
        this.e = -0.0017013;
    }

    public FisheyeMappingUtil(int x, int y, int height, int angle, int resolutionWidth, int resolutionHeight) {
        this();
        this.cameraInstallX = x;
        this.cameraInstallY = y;
        this.cameraCenterX = resolutionWidth / 2;
        this.cameraCenterY = resolutionHeight / 2;
        this.cameraInstallHeight = height;
    }

    public FisheyeMappingUtil(int height, int resolutionWidth, int resolutionHeight, int angle) {
        this(resolutionWidth / 2, resolutionHeight / 2, height, resolutionWidth, resolutionWidth, angle);
    }

    public double[][] inverseMatrix(double[][] M) {
        double[][] A = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        double a = M[0][0];
        double b = M[0][1];
        double c = M[1][0];
        double d = M[1][1];
        double t = 1.0 / (a * d - b * c);
        A[0][0] = d * t;
        A[0][1] = -1.0 * b * t;
        A[1][0] = -1.0 * c * t;
        A[1][1] = a * t;
        return A;
    }

    public double[][] dot(double[][] a, double[] b) {
        int m = a.length;
        int n = b.length;
        double[][] c = new double[1][m];
        for (int i = 0; i < m; ++i) {
            double sum = 0.0;
            for (int j = 0; j < n; ++j) {
                sum += a[i][j] * b[j];
            }
            c[0][i] = sum;
        }
        return c;
    }

    public double[] sub(double[] a, double[] b) {
        int n = a.length;
        double[] c = new double[n];
        for (int i = 0; i < n; ++i) {
            c[i] = a[i] - b[i];
        }
        return c;
    }

    public double vlen_a_b(double[] a, double[] b) {
        int n = a.length;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            sum += Math.pow(a[i], 2.0);
        }
        return Math.pow(sum, 0.5);
    }

    public double polyval(double[] m) {
        double x = this.vlen_a_b(m, m);
        double ret = 0.0;
        for (int i = 0; i < this.ss.length; ++i) {
            ret += this.ss[i] * Math.pow(x, i);
        }
        return ret;
    }

    public double[] cam2world(double[] point_cam) throws Exception {
        double[][] A = new double[][]{{this.c, this.d}, {this.e, 1.0}};
        double[] T = new double[]{this.cameraCenterX, this.cameraCenterY};
        double[] m = this.dot(this.inverseMatrix((double[][])A), this.sub(point_cam, T))[0];
        double[] ret_p = new double[]{m[0], m[1], this.polyval(m)};
        double p = this.vlen_a_b(ret_p, ret_p);
        int i = 0;
        while (i < ret_p.length) {
            int n = i++;
            ret_p[n] = ret_p[n] / p;
        }
        return ret_p;
    }
}

