/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import java.text.MessageFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class BatchJobService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    public final String SQL_DEL_JOB_EXECUTION_CONTEXT = "delete from batch_job_execution_context where job_execution_id in(select job_execution_id from batch_job_execution where job_execution_id  < ? {0})";
    public final String SQL_DEL_JOB_EXECUTION_PARAMS = "delete from batch_job_execution_params where job_execution_id in(select job_execution_id from batch_job_execution where job_execution_id  < ?  {0})";
    public final String SQL_DEL_JOB_EXECUTION = "delete from batch_job_execution where job_execution_id  < ? {0}";
    public final String SQL_DEL_JOB_INSTANCE = "delete from batch_job_instance where job_instance_id not in(select job_instance_id from batch_job_execution)";
    public final String SQL_DEL_STEP_EXECUTION = "delete from batch_step_execution where step_execution_id < ? {0} ";
    public final String SQL_DEL_STEP_EXECUTION_CONTEXT = "delete from batch_step_execution_context where step_execution_id in(select step_execution_id from batch_step_execution where step_execution_id  < ?  {0}) ";
    public final String SQL_SEL_JOB_EXECUTION_ID = "select max(job_execution_id) from batch_job_execution where end_time < ?  {0}";
    public final String SQL_SEL_STEP_EXECUTION_ID = "select max(step_execution_id)  from batch_step_execution  where end_time < ? and  job_execution_id in(select job_execution_id from batch_job_execution where job_execution_id  < ? {0})";
    public final String SQL_SEL_STEP_EXECUTION_MIN_ID = "select min(step_execution_id)  from batch_step_execution";

    public void clear(Date date, boolean onlyCompleted) {
        Long jobExecutionId = (Long)this.jdbcTemplate.queryForObject(this.sqlFormat("select max(job_execution_id) from batch_job_execution where end_time < ?  {0}", onlyCompleted), new Object[]{date}, Long.class);
        Long stepExecutionId = (Long)this.jdbcTemplate.queryForObject(this.sqlFormat("select max(step_execution_id)  from batch_step_execution  where end_time < ? and  job_execution_id in(select job_execution_id from batch_job_execution where job_execution_id  < ? {0})", onlyCompleted), new Object[]{date, jobExecutionId}, Long.class);
        if (stepExecutionId == null) {
            stepExecutionId = (Long)this.jdbcTemplate.queryForObject(this.sqlFormat("select min(step_execution_id)  from batch_step_execution", onlyCompleted), Long.class);
        }
        this.clearStepExecutionContext(stepExecutionId, onlyCompleted);
        this.clearStepExecution(stepExecutionId, onlyCompleted);
        this.clearJobExecutionParams(jobExecutionId, onlyCompleted);
        this.clearJobExecutionContext(jobExecutionId, onlyCompleted);
        this.clearJobExecution(jobExecutionId, onlyCompleted);
        this.clearJobInstance(jobExecutionId, onlyCompleted);
    }

    private void clearJobInstance(Long maxJobInstanceId, boolean onlyCompleted) {
        this.jdbcTemplate.update(this.sqlFormat("delete from batch_job_instance where job_instance_id not in(select job_instance_id from batch_job_execution)", onlyCompleted));
    }

    private void clearJobExecutionContext(Long maxJobExecutionId, boolean onlyCompleted) {
        this.jdbcTemplate.update(this.sqlFormat("delete from batch_job_execution_context where job_execution_id in(select job_execution_id from batch_job_execution where job_execution_id  < ? {0})", onlyCompleted), new Object[]{maxJobExecutionId});
    }

    private void clearJobExecutionParams(Long maxJobExecutionId, boolean onlyCompleted) {
        this.jdbcTemplate.update(this.sqlFormat("delete from batch_job_execution_params where job_execution_id in(select job_execution_id from batch_job_execution where job_execution_id  < ?  {0})", onlyCompleted), new Object[]{maxJobExecutionId});
    }

    private void clearJobExecution(Long maxJobExecutionId, boolean onlyCompleted) {
        this.jdbcTemplate.update(this.sqlFormat("delete from batch_job_execution where job_execution_id  < ? {0}", onlyCompleted), new Object[]{maxJobExecutionId});
    }

    private void clearStepExecution(Long maxJobExecutionId, boolean onlyCompleted) {
        this.jdbcTemplate.update(this.sqlFormat("delete from batch_step_execution where step_execution_id < ? {0} ", onlyCompleted), new Object[]{maxJobExecutionId});
    }

    private void clearStepExecutionContext(Long maxStepExecutionId, boolean onlyCompleted) {
        this.jdbcTemplate.update(this.sqlFormat("delete from batch_step_execution_context where step_execution_id in(select step_execution_id from batch_step_execution where step_execution_id  < ?  {0}) ", onlyCompleted), new Object[]{maxStepExecutionId});
    }

    private String sqlFormat(String sql, boolean onlyCompleted) {
        if (onlyCompleted) {
            return MessageFormat.format(sql, " and status='COMPLETED'");
        }
        return MessageFormat.format(sql, " ");
    }
}

