/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.runner;

import com.viontech.keliu.redis.RedisUtil;
import com.viontech.keliu.runner.RedisCacheClearRunner;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class RenameRunner
implements CommandLineRunner {
    private Logger logger = LoggerFactory.getLogger(RedisCacheClearRunner.class);
    private long defaultExpireTime = 345600000L;

    public void run(String ... args) throws Exception {
        this.renameKey("personUnid:gate:*");
        this.renameKey("personUnid:mall:*");
        this.renameKey("personUnid:floor:*");
        this.renameKey("personUnid:zone:*");
        this.renameKey("faceSta:gate:*");
        this.renameKey("faceSta:mall:*");
        this.renameKey("faceSta:floor:*");
        this.renameKey("faceSta:zone:*");
    }

    private void renameKey(String keyMatcher) {
        this.logger.info("\u5f00\u59cb\u6e05\u9664 {} \u7f13\u5b58\u8fc7\u671f\u6570\u636e", (Object)keyMatcher);
        Set keys = RedisUtil.getKeys((String)keyMatcher);
        if (keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            String dateStr = key.split(":")[0];
            String newkey = key.replace(dateStr, dateStr + ":day");
            RedisUtil.renameIfAbsent((String)key, (String)newkey);
        }
        this.logger.info("\u7ed3\u675f\u5904\u7406\u5386\u53f2 {} \u7f13\u5b58\u8fc7\u671fkey\u503c", (Object)keyMatcher);
    }
}

