/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.dao;

import com.viontech.keliu.model.FaceRecognition;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class FaceRecognitionDao {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private final String SQL_SELECT = "select id,device_id,channel_id,gate_id,person_id,device_serialnum,channel_serialnum,person_type,face_pic,face_pic_ext,body_pic_ext,body_pic,showbody_pic,mood,age,gender,direction,counttime,countdate,modify_time,create_time,mall_id,account_id,person_unid,showbody_pic_ext,status,face_path,body_path,face_feature,body_feature,track_info,track_time,happy_conf,history_arrival_count,today_arrival_count,track_path,unid from d_face_recognition where status = 1;";
    private final String SQL_SELECT_BYMALLID = "select id,device_id,channel_id,gate_id,person_id,device_serialnum,channel_serialnum,person_type,face_pic,face_pic_ext,body_pic_ext,body_pic,showbody_pic,mood,age,gender,direction,counttime,countdate,modify_time,create_time,mall_id,account_id,person_unid,showbody_pic_ext,status,face_path,body_path,face_feature,body_feature,track_info,track_time,happy_conf,history_arrival_count,today_arrival_count,track_path,unid from d_face_recognition where mall_id =? and countdate =? and person_type =? ";
    private final String SQL_SELECT_BATCH_PARAMETER = "select id,channel_serialnum,mall_id,person_unid,face_feature,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where countdate >? and status =0 and direction =1 and age > 0 order by id asc";
    private final String SQL_SELECT_COUNTDATE_MALLID = "select id,person_unid,channel_serialnum,face_feature from d_face_recognition where countdate = ? and mall_id = ? and direction =1 and age > 0 ";
    private final String SQL_SELECT_TRACKGROU = "SELECT ID,channel_serialnum,track_info,track_path FROM d_face_recognition WHERE countdate = ? AND channel_id = ? AND person_type =0 ORDER BY ID ASC";
    private final String SQL_SELECT_MINANDMAX_ID = "SELECT MIN(id) as minId, max(id) as maxId FROM d_face_recognition WHERE countdate >? AND status = 0 AND direction = 1 AND age > 0";
    private final String SQL_SELECT_BYMAXANDMIN_ID = "select id,channel_serialnum,mall_id,person_unid,face_feature,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where id >= ? and id <? and status =0 and direction =1 and age > 0 order by id asc";
    private final String SQL_SELECT_MIN_ID = "select id as minId from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id asc limit 1";
    private final String SQL_SELECT_MAX_ID = "select id as maxId from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id desc limit 1";
    private final String SQL_SELECT_ID = "select id from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id asc";

    public List<FaceRecognition> selectAll() {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List gates = this.jdbcTemplate.query("select id,device_id,channel_id,gate_id,person_id,device_serialnum,channel_serialnum,person_type,face_pic,face_pic_ext,body_pic_ext,body_pic,showbody_pic,mood,age,gender,direction,counttime,countdate,modify_time,create_time,mall_id,account_id,person_unid,showbody_pic_ext,status,face_path,body_path,face_feature,body_feature,track_info,track_time,happy_conf,history_arrival_count,today_arrival_count,track_path,unid from d_face_recognition where status = 1;", (RowMapper)rowMapper);
        return gates;
    }

    public List<FaceRecognition> selectByParameter(Long mallId, Date countdate, Integer personType) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,device_id,channel_id,gate_id,person_id,device_serialnum,channel_serialnum,person_type,face_pic,face_pic_ext,body_pic_ext,body_pic,showbody_pic,mood,age,gender,direction,counttime,countdate,modify_time,create_time,mall_id,account_id,person_unid,showbody_pic_ext,status,face_path,body_path,face_feature,body_feature,track_info,track_time,happy_conf,history_arrival_count,today_arrival_count,track_path,unid from d_face_recognition where mall_id =? and countdate =? and person_type =? ", (RowMapper)rowMapper, new Object[]{mallId, countdate, personType});
        return frrs;
    }

    public List<FaceRecognition> selectByCountDate(Date countDate) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,channel_serialnum,mall_id,person_unid,face_feature,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where countdate >? and status =0 and direction =1 and age > 0 order by id asc", (RowMapper)rowMapper, new Object[]{countDate});
        return frrs;
    }

    public List<FaceRecognition> selectByCountDateAndMallId(Date countdate, Long mallId) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,person_unid,channel_serialnum,face_feature from d_face_recognition where countdate = ? and mall_id = ? and direction =1 and age > 0 ", (RowMapper)rowMapper, new Object[]{countdate, mallId});
        return frrs;
    }

    public List<FaceRecognition> select4TrackGroup(Date countDate, Long channelId) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("SELECT ID,channel_serialnum,track_info,track_path FROM d_face_recognition WHERE countdate = ? AND channel_id = ? AND person_type =0 ORDER BY ID ASC", (RowMapper)rowMapper, new Object[]{countDate, channelId});
        return frrs;
    }

    public Map<String, Object> selectMinAndMaxId(Date countDate) {
        Map map = this.jdbcTemplate.queryForMap("SELECT MIN(id) as minId, max(id) as maxId FROM d_face_recognition WHERE countdate >? AND status = 0 AND direction = 1 AND age > 0", new Object[]{countDate});
        return map;
    }

    public List<FaceRecognition> selectByMaxAndMinId(Long minId, Long maxId) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,channel_serialnum,mall_id,person_unid,face_feature,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where id >= ? and id <? and status =0 and direction =1 and age > 0 order by id asc", (RowMapper)rowMapper, new Object[]{minId, maxId});
        return frrs;
    }

    public Long selectMinId(Date countDate) {
        List minIds = this.jdbcTemplate.queryForList("select id as minId from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id asc limit 1", Long.class, new Object[]{countDate});
        if (minIds == null || minIds.isEmpty()) {
            return null;
        }
        return (Long)minIds.get(0);
    }

    public Long selectMaxId(Date countDate) {
        List maxIds = this.jdbcTemplate.queryForList("select id as maxId from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id desc limit 1", Long.class, new Object[]{countDate});
        if (maxIds == null || maxIds.isEmpty()) {
            return null;
        }
        return (Long)maxIds.get(0);
    }

    public List<FaceRecognition> selectIds(Date countDate) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id asc", (RowMapper)rowMapper, new Object[]{countDate});
        return frrs;
    }
}

