/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.controller;

import com.viontech.keliu.dao.BatchJobDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.batch.core.Job;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1"})
public class JobController {
    @Autowired
    private List<Job> jobs;
    @Autowired
    private BatchJobDao batchJobDao;

    @GetMapping(value={"/jobs"})
    public List<String> getJobNames() {
        return this.jobs.parallelStream().map(Job::getName).collect(Collectors.toList());
    }

    @GetMapping(value={"/jobs/{jobName}"})
    public Map<String, Object> getJobExecution(@PathVariable(value="jobName") String jobName, @RequestParam(value="page") Integer page, @RequestParam(value="exit_code") ArrayList<String> exitCodeList) {
        Integer count;
        List list;
        if (exitCodeList != null && exitCodeList.size() != 0) {
            list = this.batchJobDao.getAllJobExecutionFilter(page, exitCodeList, false, jobName);
            count = this.batchJobDao.countJobExecutionFilter(exitCodeList, false, jobName);
        } else {
            list = this.batchJobDao.getJobExecutionByName(jobName, page);
            count = this.batchJobDao.countJobExecutionByName(jobName);
        }
        list.forEach(item -> {
            item.put("create_time", item.get("create_time").toString().substring(0, 19).replace("T", " "));
            item.put("last_updated", item.get("last_updated").toString().substring(0, 19).replace("T", " "));
            if (item.containsKey("start_time") && item.get("start_time") != null) {
                item.put("start_time", item.get("start_time").toString().substring(0, 19).replace("T", " "));
            }
            if (item.containsKey("end_time") && item.get("end_time") != null) {
                item.put("end_time", item.get("end_time").toString().substring(0, 19).replace("T", " "));
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list_data", list);
        map.put("total", count);
        return map;
    }

    @GetMapping(value={"/allJobs"})
    public Map<String, Object> getAllJobs(@RequestParam(value="page") Integer page, @RequestParam(value="exit_code") ArrayList<String> exitCodeList) {
        Integer count;
        List list;
        if (exitCodeList != null && exitCodeList.size() != 0) {
            list = this.batchJobDao.getAllJobExecutionFilter(page, exitCodeList, true, null);
            count = this.batchJobDao.countJobExecutionFilter(exitCodeList, true, null);
        } else {
            list = this.batchJobDao.getAllJobExecution(page);
            count = this.batchJobDao.countJobExecution();
        }
        list.forEach(item -> {
            item.put("create_time", item.get("create_time").toString().substring(0, 19).replace("T", " "));
            item.put("last_updated", item.get("last_updated").toString().substring(0, 19).replace("T", " "));
            if (item.containsKey("start_time") && item.get("start_time") != null) {
                item.put("start_time", item.get("start_time").toString().substring(0, 19).replace("T", " "));
            }
            if (item.containsKey("end_time") && item.get("end_time") != null) {
                item.put("end_time", item.get("end_time").toString().substring(0, 19).replace("T", " "));
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list_data", list);
        map.put("total", count);
        return map;
    }

    @GetMapping(value={"/steps/{jobExecutionId}"})
    public List<Map<String, Object>> getStepExecution(@PathVariable(value="jobExecutionId") Long jobExecutionId) {
        List list = this.batchJobDao.getStepExecutionByJobExecutionId(jobExecutionId);
        list.forEach(item -> {
            item.remove("job_execution_id");
            item.remove("filter_count");
            item.remove("read_skip_count");
            item.remove("write_skip_count");
            item.remove("process_skip_count");
            item.remove("rollback_count");
            item.put("last_updated", item.get("last_updated").toString().substring(0, 19).replace("T", " "));
            if (item.containsKey("start_time") && item.get("start_time") != null) {
                item.put("start_time", item.get("start_time").toString().substring(0, 19).replace("T", " "));
            }
            if (item.containsKey("end_time") && item.get("end_time") != null) {
                item.put("end_time", item.get("end_time").toString().substring(0, 19).replace("T", " "));
            }
        });
        return list;
    }
}

