/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration;

import com.viontech.keliu.configuration.FtpConfiguration;
import com.viontech.keliu.ftp.FTPClientHelper;
import com.viontech.keliu.oss.OssClientHelper;
import com.viontech.keliu.storage.FtpFeatureStorage;
import com.viontech.keliu.storage.FtpImageStorage;
import com.viontech.keliu.storage.LocalFeatureStorage;
import com.viontech.keliu.storage.LocalImageStorage;
import com.viontech.keliu.storage.OssFeatureStorage;
import com.viontech.keliu.storage.OssImageStorage;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.storage.StorageDatePathGenerator;
import com.viontech.keliu.storage.StoragePathGenerator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={FtpConfiguration.class})
public class StorageConfiguration {
    @Bean(value={"imageStorage"})
    @ConditionalOnBean(value={OssClientHelper.class})
    public Storage ossImageStorage(StoragePathGenerator imagePathGenerator, OssClientHelper ossClientHelper) {
        System.out.println("ossImageStorage--------------------------");
        OssImageStorage ossImageStorage = new OssImageStorage();
        ossImageStorage.setOssClientHelper(ossClientHelper);
        ossImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ossImageStorage;
    }

    @Bean(value={"featureStorage"})
    @ConditionalOnBean(value={OssClientHelper.class})
    public Storage ossFeatureStorage(StoragePathGenerator featurePathGenerator, OssClientHelper ossClientHelper) {
        System.out.println("ossFeatureStorage----------------------");
        OssFeatureStorage ossFeatureStorage = new OssFeatureStorage();
        ossFeatureStorage.setOssClientHelper(ossClientHelper);
        ossFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return ossFeatureStorage;
    }

    @Bean(value={"trackStorage"})
    @ConditionalOnBean(value={OssClientHelper.class})
    public Storage ossTrackStorage(StoragePathGenerator trackPathGenerator, OssClientHelper ossClientHelper) {
        System.out.println("\u914d\u7f6e\u4e00\u4e2a\u8f68\u8ff9\u6587\u4ef6\u5b58\u50a8\u5668");
        OssFeatureStorage ossFeatureStorage = new OssFeatureStorage();
        ossFeatureStorage.setOssClientHelper(ossClientHelper);
        ossFeatureStorage.setStoragePathGenerator(trackPathGenerator);
        return ossFeatureStorage;
    }

    @Bean(value={"imageStorage"})
    @ConditionalOnBean(value={FTPClientHelper.class})
    @ConditionalOnMissingBean(name={"imageStorage"})
    public Storage ftpImageStorage(StoragePathGenerator imagePathGenerator, FTPClientHelper ftpClientHelper) {
        System.out.println(">>>>>>>>>>>FTP\u5b58\u50a8\u5668\u6784\u5efa\u6210\u529f");
        FtpImageStorage ftpImageStorage = new FtpImageStorage();
        ftpImageStorage.setFtpClientHelper(ftpClientHelper);
        ftpImageStorage.setStoragePathGenerator(imagePathGenerator);
        return ftpImageStorage;
    }

    @Bean(value={"trackStorage"})
    @ConditionalOnBean(value={FTPClientHelper.class})
    @ConditionalOnMissingBean(name={"trackStorage"})
    public Storage ftpTrackStorage(StoragePathGenerator trackPathGenerator, FTPClientHelper ftpClientHelper) {
        FtpFeatureStorage ftpFeatureStorage = new FtpFeatureStorage();
        ftpFeatureStorage.setFtpClientHelper(ftpClientHelper);
        ftpFeatureStorage.setStoragePathGenerator(trackPathGenerator);
        return ftpFeatureStorage;
    }

    @Bean(value={"imageStorage"})
    @ConditionalOnMissingBean(name={"imageStorage"})
    public Storage localImageStorage(StoragePathGenerator imagePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalImageStorage localImageStorage = new LocalImageStorage();
        if (path == null || path.trim().isEmpty()) {
            path = System.getProperty("java.io.tmpdir");
        }
        System.out.println(">>>>>>>>>>>\u672c\u5730\u5b58\u50a8\u5668\u6784\u5efa\u6210\u529f" + path);
        localImageStorage.setBasePath(path);
        localImageStorage.setStoragePathGenerator(imagePathGenerator);
        return localImageStorage;
    }

    @Bean(value={"trackStorage"})
    @ConditionalOnMissingBean(name={"trackStorage"})
    public Storage localTrackStorage(StoragePathGenerator trackPathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalFeatureStorage localFeatureStorage = new LocalFeatureStorage();
        if (path == null || path.trim().isEmpty()) {
            localFeatureStorage.setBasePath(System.getProperty("java.io.tmpdir"));
        } else {
            localFeatureStorage.setBasePath(path);
        }
        localFeatureStorage.setStoragePathGenerator(trackPathGenerator);
        return localFeatureStorage;
    }

    @Bean(value={"featureStorage"})
    @ConditionalOnBean(value={FTPClientHelper.class})
    @ConditionalOnMissingBean(name={"featureStorage"})
    public Storage ftpFeatureStorage(StoragePathGenerator featurePathGenerator, FTPClientHelper ftpClientHelper) {
        FtpFeatureStorage ftpFeatureStorage = new FtpFeatureStorage();
        ftpFeatureStorage.setFtpClientHelper(ftpClientHelper);
        ftpFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return ftpFeatureStorage;
    }

    @Bean(value={"featureStorage"})
    @ConditionalOnMissingBean(name={"featureStorage"})
    public Storage localFeatureStorage(StoragePathGenerator featurePathGenerator, @Value(value="${vion.storage.path:}") String path) {
        LocalFeatureStorage localFeatureStorage = new LocalFeatureStorage();
        if (path == null || path.trim().isEmpty()) {
            localFeatureStorage.setBasePath(System.getProperty("java.io.tmpdir"));
        } else {
            localFeatureStorage.setBasePath(path);
        }
        localFeatureStorage.setStoragePathGenerator(featurePathGenerator);
        return localFeatureStorage;
    }

    @Bean(value={"imagePathGenerator"})
    public StoragePathGenerator imagePathGenerator() {
        StorageDatePathGenerator storagePathGenerator = new StorageDatePathGenerator();
        StringBuilder sb = new StringBuilder();
        sb.append("picture").append("/");
        storagePathGenerator.setPathPrefix(sb.toString());
        return storagePathGenerator;
    }

    @Bean(value={"featurePathGenerator"})
    public StoragePathGenerator featurePathGenerator() {
        StorageDatePathGenerator storagePathGenerator = new StorageDatePathGenerator();
        StringBuilder sb = new StringBuilder();
        sb.append("feature").append("/");
        storagePathGenerator.setPathPrefix(sb.toString());
        storagePathGenerator.setPathPostfix(".feature");
        return storagePathGenerator;
    }

    @Bean(value={"trackPathGenerator"})
    public StoragePathGenerator trackPathGenerator() {
        return name -> name;
    }
}

