/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.configuration;

import com.viontech.keliu.oss.OssClientHelper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OssConfiguration {
    @Value(value="${oss.config.endPoint:}")
    private String endPoint;
    @Value(value="${oss.config.accessKeyId:}")
    private String accessKeyId;
    @Value(value="${oss.config.accessKeySecret:}")
    private String accessKeySecret;
    @Value(value="${oss.config.bucket:}")
    private String bucket;

    @Bean
    @ConditionalOnProperty(value={"oss.config.bucket"})
    public OssClientHelper ossClientHelper() {
        OssClientHelper helper = new OssClientHelper();
        helper.setKey(this.accessKeyId);
        helper.setSecret(this.accessKeySecret);
        helper.setBucket(this.bucket);
        helper.setEndPoint(this.endPoint);
        return helper;
    }
}

