/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.batch.item.stream.BussinessValidItemStream;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.CountDataContent;
import com.viontech.keliu.model.Zone;
import com.viontech.keliu.model.ZoneGate;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="zoneCountData2RedisWriter")
public class ZoneCountData2RedisWriter
extends BussinessValidItemStream<CountDataContent>
implements ItemStreamWriter<CountDataContent> {
    private Logger logger = LoggerFactory.getLogger(ZoneCountData2RedisWriter.class);
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private OrgCacheService orgCacheService;
    @Value(value="${vion.time-offset.mall-day:0}")
    private int mallDayTimeOffset;

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        super.open(executionContext);
        this.updateExecutionContext();
    }

    private void updateExecutionContext() {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
        Map gate2ZoneMap = this.orgCacheService.getGate2ZoneMap();
        executionContext.put("gate2ZoneMap", (Object)gate2ZoneMap);
        Map zoneMap = this.orgCacheService.getZoneMap();
        executionContext.put("zoneMap", (Object)zoneMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        this.updateExecutionContext();
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("channelMap");
        executionContext.remove("gate2ZoneMap");
        executionContext.remove("zoneMap");
        super.close();
    }

    protected Date getCounttime(CountDataContent countDataContent) {
        return countDataContent.getCountdate();
    }

    protected Long getMallId(CountDataContent countDataContent) {
        return countDataContent.getMallId();
    }

    public void write(List<? extends CountDataContent> items) throws Exception {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map channelMap = (Map)executionContext.get("channelMap");
        Map gate2ZoneMap = (Map)executionContext.get("gate2ZoneMap");
        Map zoneMap = (Map)executionContext.get("zoneMap");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        for (CountDataContent countDataContent : items) {
            List list;
            Channel channel = (Channel)channelMap.get(countDataContent.getChannelno());
            if (channel == null) continue;
            countDataContent.setMallId(channel.getMallId());
            if (!this.isValid((Object)countDataContent) || channel.getType() != null && channel.getType() == 1 && (countDataContent.getStatus() == null || countDataContent.getStatus() != 1) || (list = (List)gate2ZoneMap.get(String.valueOf(channel.getGateId()))) == null || list.size() <= 0) continue;
            Date counttime = countDataContent.getCreateTime();
            String dateStr = sdf.format(counttime);
            String dayDateStr = sdf.format(DateUtil.addHours((Date)counttime, (int)this.mallDayTimeOffset));
            dayDateStr = dayDateStr.substring(0, 8);
            StringBuilder sb = new StringBuilder();
            sb.append("countData:minute:zone:");
            sb.append(dateStr.substring(0, 11));
            String minueKeyPrefix = sb.toString();
            sb.setLength(0);
            sb.append("countData:hour:zone:");
            sb.append(dateStr.substring(0, 10));
            String hourKeyPrefix = sb.toString();
            sb.setLength(0);
            sb.append("countData:day:zone:");
            sb.append(dayDateStr);
            String dayKeyPrefix = sb.toString();
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            Date countDate = countDataContent.getCreateTime();
            countDate = DateUtil.setMilliseconds((Date)countDate, (int)0);
            countDate = DateUtil.setSeconds((Date)countDate, (int)0);
            Date minuteCountDate = DateUtil.setMinutes((Date)countDate, (int)(DateUtil.getMinute((Date)countDate) / 10 * 10));
            Date hourCountDate = DateUtil.setMinutes((Date)countDate, (int)0);
            for (ZoneGate zoneGate : list) {
                map.clear();
                long zoneId = zoneGate.getZoneId();
                Zone zone = (Zone)zoneMap.get(String.valueOf(zoneId));
                if (zone == null) continue;
                int type = zoneGate.getType();
                map.put("mallId", channel.getMallId());
                map.put("accountId", channel.getAccountId());
                map.put("zoneId", Long.valueOf(zoneId));
                map.put("floorId", Long.valueOf(zone.getFloorId()));
                sb.setLength(0);
                sb.append(minueKeyPrefix);
                sb.append(":");
                sb.append(zoneId);
                String key = sb.toString();
                BoundHashOperations boundHashOps = this.redisTemplate.boundHashOps((Object)key);
                map.put("createTime", minuteCountDate);
                this.incrementValue(countDataContent, type, boundHashOps);
                boundHashOps.putAll(map);
                sb.setLength(0);
                sb.append(hourKeyPrefix);
                sb.append(":");
                sb.append(zoneId);
                key = sb.toString();
                boundHashOps = this.redisTemplate.boundHashOps((Object)key);
                map.put("createTime", hourCountDate);
                this.incrementValue(countDataContent, type, boundHashOps);
                boundHashOps.putAll(map);
                Date dayCountDate = DateUtil.parse((String)"yyyyMMdd", (String)dayDateStr);
                map.put("createTime", dayCountDate);
                sb.setLength(0);
                sb.append(dayKeyPrefix);
                sb.append(":");
                sb.append(zoneId);
                key = sb.toString();
                boundHashOps = this.redisTemplate.boundHashOps((Object)key);
                this.incrementValue(countDataContent, type, boundHashOps);
                boundHashOps.putAll(map);
            }
        }
    }

    private void incrementValue(CountDataContent item, int type, BoundHashOperations boundHashOps) {
        if (type == 3) {
            boundHashOps.increment((Object)"outsideInum", (long)item.getInnum());
            boundHashOps.increment((Object)"outsideOutnum", (long)item.getOutnum());
        } else if (type == 1) {
            boundHashOps.increment((Object)"innum", (long)item.getInnum());
            boundHashOps.increment((Object)"outnum", (long)item.getOutnum());
        } else if (type == 2) {
            boundHashOps.increment((Object)"innum", (long)item.getOutnum());
            boundHashOps.increment((Object)"outnum", (long)item.getInnum());
        }
    }
}

