/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.batch.item.stream.BussinessValidItemStream;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.CountDataContent;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="gateCountData2RedisWriter")
public class GateCountData2RedisWriter
extends BussinessValidItemStream<CountDataContent>
implements ItemStreamWriter<CountDataContent> {
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private OrgCacheService orgCacheService;
    @Value(value="${vion.time-offset.mall-day:0}")
    private int mallDayTimeOffset;

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        super.open(executionContext);
        this.updateExecutionContext();
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        this.updateExecutionContext();
    }

    private void updateExecutionContext() {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("channelMap");
        super.close();
    }

    protected Date getCounttime(CountDataContent countDataContent) {
        return countDataContent.getCountdate();
    }

    protected Long getMallId(CountDataContent countDataContent) {
        return countDataContent.getMallId();
    }

    public void write(List<? extends CountDataContent> items) throws Exception {
        Map channelMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("channelMap");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        for (CountDataContent countDataContent : items) {
            Long gateId;
            Channel channel = (Channel)channelMap.get(countDataContent.getChannelno());
            if (channel == null) continue;
            countDataContent.setMallId(channel.getMallId());
            if (!this.isValid((Object)countDataContent) || channel.getType() != null && channel.getType() == 1 && (countDataContent.getStatus() == null || countDataContent.getStatus() != 1) || (gateId = channel.getGateId()) == null) continue;
            Date countDate = countDataContent.getCreateTime();
            Date counttime = countDataContent.getCreateTime();
            String dateStr = sdf.format(counttime);
            String dayDateStr = sdf.format(DateUtil.addHours((Date)counttime, (int)this.mallDayTimeOffset));
            dayDateStr = dayDateStr.substring(0, 8);
            countDate = DateUtil.setMilliseconds((Date)countDate, (int)0);
            countDate = DateUtil.setSeconds((Date)countDate, (int)0);
            Date minuteCountDate = DateUtil.setMinutes((Date)countDate, (int)(DateUtil.getMinute((Date)countDate) / 10 * 10));
            Date hourCountDate = DateUtil.setMinutes((Date)countDate, (int)0);
            StringBuilder sb = new StringBuilder();
            sb.append("countData:minute:gate:");
            sb.append(dateStr.substring(0, 11));
            String minueKeyPrefix = sb.toString();
            sb.setLength(0);
            sb.append("countData:hour:gate:");
            sb.append(dateStr.substring(0, 10));
            String hourKeyPrefix = sb.toString();
            sb.setLength(0);
            sb.append("countData:day:gate:");
            sb.append(dayDateStr);
            String dayKeyPrefix = sb.toString();
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            map.put("gateId", gateId);
            map.put("mallId", channel.getMallId());
            map.put("accountId", channel.getAccountId());
            sb.setLength(0);
            sb.append(minueKeyPrefix);
            sb.append(":");
            sb.append(gateId.intValue());
            String key = sb.toString();
            BoundHashOperations boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            boundHashOps.increment((Object)"innum", (long)countDataContent.getInnum());
            boundHashOps.increment((Object)"outnum", (long)countDataContent.getOutnum());
            map.put("createTime", minuteCountDate);
            boundHashOps.putAll(map);
            sb.setLength(0);
            sb.append(hourKeyPrefix);
            sb.append(":");
            sb.append(gateId.intValue());
            key = sb.toString();
            boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            map.put("createTime", hourCountDate);
            boundHashOps.increment((Object)"innum", (long)countDataContent.getInnum());
            boundHashOps.increment((Object)"outnum", (long)countDataContent.getOutnum());
            boundHashOps.putAll(map);
            sb.setLength(0);
            sb.append(dayKeyPrefix);
            sb.append(":");
            sb.append(gateId.intValue());
            key = sb.toString();
            boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            Date dayCountDate = DateUtil.parse((String)"yyyyMMdd", (String)dayDateStr);
            map.put("createTime", dayCountDate);
            boundHashOps.increment((Object)"innum", (long)countDataContent.getInnum());
            boundHashOps.increment((Object)"outnum", (long)countDataContent.getOutnum());
            boundHashOps.putAll(map);
        }
    }
}

