/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.model.FaceDataContent;
import com.viontech.keliu.model.FloorGate;
import com.viontech.keliu.model.Zone;
import com.viontech.keliu.model.ZoneGate;
import com.viontech.keliu.service.OrgCacheService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Component;

@Component(value="faceDataSta2RedisWriter")
public class FaceDataSta2RedisWriter
implements ItemStreamWriter<FaceDataContent> {
    private final Logger logger = LoggerFactory.getLogger(FaceDataSta2RedisWriter.class);
    private static final Object GATE_SYNC = new Object();
    private static final Object MALL_SYNC = new Object();
    private static final Object FLOOR_SYNC = new Object();
    private static final Object ZONE_SYNC = new Object();
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private OrgCacheService orgCacheService;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        this.updateExecutionContext();
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        this.updateExecutionContext();
    }

    private void updateExecutionContext() {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
        Map gate2ZoneMap = this.orgCacheService.getGate2ZoneMap();
        executionContext.put("gate2ZoneMap", (Object)gate2ZoneMap);
        Map gate2FloorMap = this.orgCacheService.getGate2FloorMap();
        executionContext.put("gate2FloorMap", (Object)gate2FloorMap);
        Map gate2MallMap = this.orgCacheService.getGate2MallMap();
        executionContext.put("gate2MallMap", (Object)gate2MallMap);
        Map zoneMap = this.orgCacheService.getZoneMap();
        executionContext.put("zoneMap", (Object)zoneMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("channelMap");
        executionContext.remove("gate2ZoneMap");
        executionContext.remove("gate2FloorMap");
        executionContext.remove("gate2MallMap");
        executionContext.remove("zoneMap");
        this.executionContextThreadLocal.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(List<? extends FaceDataContent> items) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        this.logger.info("\u83b7\u53d6FaceDataSta2RedisWriter executionContext\u5730\u5740:{}", (Object)System.identityHashCode(executionContext));
        Map gate2ZoneMap = (Map)executionContext.get("gate2ZoneMap");
        Map zoneMap = (Map)executionContext.get("zoneMap");
        Map gate2MallMap = (Map)executionContext.get("gate2MallMap");
        for (FaceDataContent faceDataContent : items) {
            List zoneGates;
            Object object;
            String personUnidKey;
            if (faceDataContent.getDirection() != 1) {
                this.logger.debug("\u65b9\u5411\u4e0d\u662f\u8fdb,\u8df3\u8fc7");
                continue;
            }
            Long gateId = faceDataContent.getGateId();
            if (gateId == null) {
                this.logger.warn("\u8bbe\u5907{}\u6ca1\u6709\u7ed1\u5b9a\u76d1\u63a7\u70b9", (Object)faceDataContent.getChannelSerialnum());
                continue;
            }
            String dateStr = sdf.format(faceDataContent.getCountDate());
            Long mallId = faceDataContent.getMallId();
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            map.put("mallId", faceDataContent.getMallId());
            map.put("accountId", faceDataContent.getAccountId());
            map.put("countDate", faceDataContent.getCountDate());
            map.put("gateId", gateId);
            StringBuilder sb = new StringBuilder();
            sb.append("faceSta:").append("day:").append("gate:").append(dateStr).append(":").append(gateId);
            StringBuilder personSb = new StringBuilder();
            personSb.append("personUnid:").append("day:").append("gate:").append(dateStr).append(":").append(gateId);
            String faceStaKey = sb.toString();
            BoundHashOperations boundHashOps = this.redisTemplate.boundHashOps((Object)faceStaKey);
            if (!this.redisTemplate.expire((Object)faceStaKey, 2L, TimeUnit.DAYS).booleanValue()) {
                Object object2 = GATE_SYNC;
                synchronized (object2) {
                    if (!this.redisTemplate.hasKey((Object)faceStaKey).booleanValue()) {
                        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u76d1\u63a7\u70b9> <\u5929\u7ea7> \u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)faceStaKey);
                        this.loadGateDayFaceSta(gateId.longValue(), faceDataContent.getCountDate(), boundHashOps);
                    }
                }
            }
            if (!this.redisTemplate.expire((Object)(personUnidKey = personSb.toString()), 2L, TimeUnit.DAYS).booleanValue()) {
                object = GATE_SYNC;
                synchronized (object) {
                    if (!this.redisTemplate.hasKey((Object)personUnidKey).booleanValue()) {
                        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u76d1\u63a7\u70b9> <\u5929\u7ea7> personUnid\u7f13\u5b58 key:{}", (Object)personUnidKey);
                        this.loadGateDayPersonUnid(personUnidKey, gateId, faceDataContent.getCountDate());
                    }
                }
            }
            this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(personUnidKey, faceDataContent.getPersonId()));
            boundHashOps.putAll(map);
            if (gate2MallMap.containsKey(String.valueOf(gateId))) {
                sb.setLength(0);
                sb.append("faceSta:").append("day:").append("mall:").append(dateStr).append(":").append(mallId);
                faceStaKey = sb.toString();
                boundHashOps = this.redisTemplate.boundHashOps((Object)faceStaKey);
                if (!this.redisTemplate.expire((Object)faceStaKey, 2L, TimeUnit.DAYS).booleanValue()) {
                    object = MALL_SYNC;
                    synchronized (object) {
                        if (!this.redisTemplate.hasKey((Object)faceStaKey).booleanValue()) {
                            this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u5546\u573a> <\u5929\u7ea7> \u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)faceStaKey);
                            this.loadMallDayFaceSta(mallId, faceDataContent.getCountDate(), boundHashOps);
                        }
                    }
                }
                personSb.setLength(0);
                personSb.append("personUnid:").append("day:").append("mall:").append(dateStr).append(":").append(mallId);
                personUnidKey = personSb.toString();
                if (!this.redisTemplate.expire((Object)personUnidKey, 2L, TimeUnit.DAYS).booleanValue()) {
                    object = MALL_SYNC;
                    synchronized (object) {
                        if (!this.redisTemplate.hasKey((Object)personUnidKey).booleanValue()) {
                            this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u5546\u573a> <\u5929\u7ea7> personUnid\u7f13\u5b58 key:{}", (Object)personUnidKey);
                            this.loadMallDayPersonUnid(personUnidKey, mallId, faceDataContent.getCountDate());
                        }
                    }
                }
                this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(personUnidKey, faceDataContent.getPersonId()));
                boundHashOps.putAll(map);
            }
            Map floor2ZoneMap = (Map)executionContext.get("gate2FloorMap");
            List floorGates = (List)floor2ZoneMap.get(String.valueOf(gateId));
            if (floor2ZoneMap == null) {
                System.out.println();
            }
            if (floorGates != null && floorGates.size() > 0) {
                for (FloorGate floorGate : floorGates) {
                    Object object3;
                    int type = floorGate.getType();
                    if (type != 1) continue;
                    long floorId = floorGate.getFloorId();
                    map.put("floorId", Long.valueOf(floorId));
                    sb.setLength(0);
                    sb.append("faceSta:").append("day:").append("floor:").append(dateStr).append(":").append(floorId);
                    faceStaKey = sb.toString();
                    boundHashOps = this.redisTemplate.boundHashOps((Object)faceStaKey);
                    if (!this.redisTemplate.expire((Object)faceStaKey, 2L, TimeUnit.DAYS).booleanValue()) {
                        object3 = FLOOR_SYNC;
                        synchronized (object3) {
                            if (!this.redisTemplate.hasKey((Object)faceStaKey).booleanValue()) {
                                this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u697c\u5c42> <\u5929\u7ea7> \u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)faceStaKey);
                                this.loadFloorDayFaceSta(floorId, faceDataContent.getCountDate(), boundHashOps);
                            }
                        }
                    }
                    personSb.setLength(0);
                    personSb.append("personUnid:").append("day:").append("floor:").append(dateStr).append(":").append(floorId);
                    personUnidKey = personSb.toString();
                    if (!this.redisTemplate.expire((Object)personUnidKey, 2L, TimeUnit.DAYS).booleanValue()) {
                        object3 = FLOOR_SYNC;
                        synchronized (object3) {
                            if (!this.redisTemplate.hasKey((Object)personUnidKey).booleanValue()) {
                                this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u697c\u5c42> <\u5929\u7ea7> personUnid\u7f13\u5b58 key:{}", (Object)personUnidKey);
                                this.loadFloorDayPersonUnid(personUnidKey, floorId, faceDataContent.getCountDate());
                            }
                        }
                    }
                    this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(personUnidKey, faceDataContent.getPersonId()));
                    boundHashOps.putAll(map);
                }
            }
            if ((zoneGates = (List)gate2ZoneMap.get(String.valueOf(gateId))) == null || zoneGates.size() <= 0) continue;
            for (ZoneGate zoneGate : zoneGates) {
                Zone zone;
                Object object4;
                int type = zoneGate.getType();
                if (type != 1) continue;
                long zoneId = zoneGate.getZoneId();
                map.put("zoneId", Long.valueOf(zoneId));
                sb.setLength(0);
                sb.append("faceSta:").append("day:").append("zone:").append(dateStr).append(":").append(zoneId);
                faceStaKey = sb.toString();
                boundHashOps = this.redisTemplate.boundHashOps((Object)faceStaKey);
                if (!this.redisTemplate.expire((Object)faceStaKey, 2L, TimeUnit.DAYS).booleanValue()) {
                    object4 = ZONE_SYNC;
                    synchronized (object4) {
                        if (!this.redisTemplate.hasKey((Object)faceStaKey).booleanValue()) {
                            this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u533a\u57df> <\u5929\u7ea7> \u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)faceStaKey);
                            this.loadZoneDayFaceSta(zoneId, faceDataContent.getCountDate(), boundHashOps);
                        }
                    }
                }
                personSb.setLength(0);
                personSb.append("personUnid:").append("day:").append("zone:").append(dateStr).append(":").append(zoneId);
                personUnidKey = personSb.toString();
                if (!this.redisTemplate.expire((Object)personUnidKey, 2L, TimeUnit.DAYS).booleanValue()) {
                    object4 = ZONE_SYNC;
                    synchronized (object4) {
                        if (!this.redisTemplate.hasKey((Object)personUnidKey).booleanValue()) {
                            this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u533a\u57df> <\u5929\u7ea7> personUnid\u7f13\u5b58 key:{}", (Object)personUnidKey);
                            this.loadZoneDayPersonUnid(personUnidKey, zoneId, faceDataContent.getCountDate());
                        }
                    }
                }
                if ((zone = (Zone)zoneMap.get(String.valueOf(zoneId))) == null) {
                    this.logger.info("zoneId {} null , zoneMap size is {}", (Object)zoneId, (Object)zoneMap.size());
                } else {
                    map.put("floorId", Long.valueOf(zone.getFloorId()));
                }
                this.incrementValue(boundHashOps, faceDataContent, this.isRepeatPersonUnid(personUnidKey, faceDataContent.getPersonId()));
                boundHashOps.putAll(map);
            }
        }
    }

    private void loadZoneDayPersonUnid(String key, long zoneId, Date countDate) {
        List list = this.jdbcTemplate.queryForList("select person_unid from d_face_recognition where gate_id in (select gate_id from r_zone_gate where zone_id=?) AND countdate=?", new Object[]{zoneId, countDate}, String.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.redisTemplate.boundSetOps((Object)key).add(list.toArray());
        this.redisTemplate.expire((Object)key, 2L, TimeUnit.DAYS);
    }

    private void loadFloorDayPersonUnid(String key, long floorId, Date countDate) {
        List list = this.jdbcTemplate.queryForList("select person_unid from d_face_recognition where gate_id in (select gate_id from r_floor_gate where floor_id=?) AND countdate=?", new Object[]{floorId, countDate}, String.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.redisTemplate.boundSetOps((Object)key).add(list.toArray());
        this.redisTemplate.expire((Object)key, 2L, TimeUnit.DAYS);
    }

    private void loadGateDayPersonUnid(String key, Long gateId, Date countDate) {
        List list = this.jdbcTemplate.queryForList("select person_unid from d_face_recognition where gate_id=? and countdate=?", new Object[]{gateId, countDate}, String.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.redisTemplate.boundSetOps((Object)key).add(list.toArray());
        this.redisTemplate.expire((Object)key, 2L, TimeUnit.DAYS);
    }

    private void loadMallDayPersonUnid(String key, Long mallId, Date countDate) {
        List list = this.jdbcTemplate.queryForList("select person_unid from d_face_recognition where mall_id=? and countdate=?", new Object[]{mallId, countDate}, String.class);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.redisTemplate.boundSetOps((Object)key).add(list.toArray());
        this.redisTemplate.expire((Object)key, 2L, TimeUnit.DAYS);
    }

    private void loadMallDayFaceSta(Long mallId, Date countDate, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT *  FROM d_mall_day_face_recognition_sta WHERE mall_id=? AND countdate=? LIMIT 1", new Object[]{mallId, countDate}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadGateDayFaceSta(long gateId, Date countDate, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT *  FROM d_gate_day_face_recognition_sta WHERE gate_id=? AND countdate=? LIMIT 1", new Object[]{gateId, countDate}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadFloorDayFaceSta(long floorId, Date countDate, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT *  FROM d_floor_day_face_recognition_sta WHERE floor_id=? AND countdate=? LIMIT 1", new Object[]{floorId, countDate}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadZoneDayFaceSta(long zoneId, Date countDate, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT *  FROM d_zone_day_face_recognition_sta WHERE floor_id=? AND countdate=? LIMIT 1", new Object[]{zoneId, countDate}, this.getRowCallbackHandler(boundHashOps));
    }

    private RowCallbackHandler getRowCallbackHandler(BoundHashOperations boundHashOps) {
        return rs -> {
            String[] femaleStage;
            int count;
            int i;
            String[] maleStage;
            boundHashOps.increment((Object)"personMantime", (long)rs.getInt("person_mantime"));
            boundHashOps.increment((Object)"personCount", (long)rs.getInt("person_count"));
            boundHashOps.increment((Object)"customMantime", (long)rs.getInt("custom_mantime"));
            boundHashOps.increment((Object)"customCount", (long)rs.getInt("custom_count"));
            boundHashOps.increment((Object)"staffCount", (long)rs.getInt("staff_count"));
            boundHashOps.increment((Object)"staffMantime", (long)rs.getInt("staff_mantime"));
            boundHashOps.increment((Object)"maleMantime", (long)rs.getInt("male_mantime"));
            boundHashOps.increment((Object)"maleCount", (long)rs.getInt("male_count"));
            boundHashOps.increment((Object)"femaleMantime", (long)rs.getInt("female_mantime"));
            boundHashOps.increment((Object)"femaleCount", (long)rs.getInt("female_count"));
            boundHashOps.increment((Object)"newCustomCount", (long)rs.getInt("new_custom_count"));
            boundHashOps.increment((Object)"newMaleCount", (long)rs.getInt("new_male_count"));
            boundHashOps.increment((Object)"newFemaleCount", (long)rs.getInt("new_female_count"));
            boundHashOps.increment((Object)"regularCustomCount", (long)rs.getInt("regular_custom_count"));
            boundHashOps.increment((Object)"regularMaleCount", (long)rs.getInt("regular_male_count"));
            boundHashOps.increment((Object)"regularFemaleCount", (long)rs.getInt("regular_female_count"));
            if (rs.getString("male_stage") != null) {
                maleStage = rs.getString("male_stage").split(",");
                for (i = 0; i < maleStage.length; ++i) {
                    count = Integer.parseInt(maleStage[i].trim());
                    if (count <= 0) continue;
                    boundHashOps.increment((Object)("maleDetail" + i), (long)count);
                }
            }
            if (rs.getString("female_stage") != null) {
                femaleStage = rs.getString("female_stage").split(",");
                for (i = 0; i < femaleStage.length; ++i) {
                    count = Integer.parseInt(femaleStage[i].trim());
                    if (count <= 0) continue;
                    boundHashOps.increment((Object)("femaleDetail" + i), (long)count);
                }
            }
            if (rs.getString("new_male_stage") != null) {
                maleStage = rs.getString("new_male_stage").split(",");
                for (i = 0; i < maleStage.length; ++i) {
                    count = Integer.parseInt(maleStage[i].trim());
                    if (count <= 0) continue;
                    boundHashOps.increment((Object)("newMaleDetail" + i), (long)count);
                }
            }
            if (rs.getString("new_female_stage") != null) {
                femaleStage = rs.getString("new_female_stage").split(",");
                for (i = 0; i < femaleStage.length; ++i) {
                    count = Integer.parseInt(femaleStage[i].trim());
                    if (count <= 0) continue;
                    boundHashOps.increment((Object)("newFemaleDetail" + i), (long)count);
                }
            }
            if (rs.getString("regular_male_stage") != null) {
                maleStage = rs.getString("regular_male_stage").split(",");
                for (i = 0; i < maleStage.length; ++i) {
                    count = Integer.parseInt(maleStage[i].trim());
                    if (count <= 0) continue;
                    boundHashOps.increment((Object)("regularMaleDetail" + i), (long)count);
                }
            }
            if (rs.getString("regular_female_stage") != null) {
                femaleStage = rs.getString("regular_female_stage").split(",");
                for (i = 0; i < femaleStage.length; ++i) {
                    count = Integer.parseInt(femaleStage[i].trim());
                    if (count <= 0) continue;
                    boundHashOps.increment((Object)("regularFemaleDetail" + i), (long)count);
                }
            }
        };
    }

    private boolean isRepeatPersonUnid(String key, String personUnid) {
        long result = this.redisTemplate.boundSetOps((Object)key).add(new Object[]{personUnid});
        return result <= 0L;
    }

    private void incrementValue(BoundHashOperations boundHashOps, FaceDataContent faceDataContent, boolean repeatPersonUnid) {
        boolean infoValidData = false;
        if (faceDataContent.getGender() >= 0 && faceDataContent.getAge() >= 0) {
            infoValidData = true;
        }
        String genderStr = faceDataContent.getGender() == 1 ? "male" : "female";
        String infoKey = genderStr + "Detail" + faceDataContent.getAge();
        boundHashOps.increment((Object)"personMantime", 1L);
        if (faceDataContent.getPersonType() == null || faceDataContent.getPersonType() != 1) {
            if (infoValidData) {
                String manTimeKey = genderStr + "Mantime";
                boundHashOps.increment((Object)manTimeKey, 1L);
            }
            boundHashOps.increment((Object)"customMantime", 1L);
        } else {
            boundHashOps.increment((Object)"staffMantime", 1L);
        }
        boundHashOps.expire(2L, TimeUnit.DAYS);
        if (repeatPersonUnid) {
            return;
        }
        boundHashOps.increment((Object)"personCount", 1L);
        if (faceDataContent.getPersonType() == null || faceDataContent.getPersonType() != 1) {
            boundHashOps.increment((Object)"customCount", 1L);
            if (infoValidData) {
                String countKey = genderStr + "Count";
                boundHashOps.increment((Object)countKey, 1L);
                boundHashOps.increment((Object)infoKey, 1L);
            }
        } else {
            boundHashOps.increment((Object)"staffCount", 1L);
        }
    }
}

