/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.writer;

import com.viontech.keliu.model.CountDataContent;
import com.viontech.keliu.model.FaceDataContent;
import com.viontech.keliu.model.Gate;
import com.viontech.keliu.redis.RedisUtil;
import com.viontech.keliu.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.ItemStreamWriter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="faceData2CountDataWriter")
public class FaceData2CountDataWriter
implements ItemStreamWriter<FaceDataContent> {
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();
    private Logger logger = LoggerFactory.getLogger(FaceData2CountDataWriter.class);
    @Resource
    private RedisTemplate redisTemplate;
    ThreadLocal<SimpleDateFormat> sdfThreadLocal = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMddHHmmss"));

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
    }

    public void close() throws ItemStreamException {
    }

    public void write(List<? extends FaceDataContent> items) throws Exception {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map channelMap = (Map)executionContext.get("channelMap");
        SimpleDateFormat sdfL = new SimpleDateFormat(DateUtil.FORMAT_LONG);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHH");
        Map gateMap = (Map)executionContext.get("gateMap");
        HashMap<String, CountDataContent> dataMap = new HashMap<String, CountDataContent>();
        for (FaceDataContent faceDataContent : items) {
            Gate gate;
            if (gateMap != null && !gateMap.isEmpty() && (gate = (Gate)gateMap.get(String.valueOf(faceDataContent.getGateId()))) != null && gate.getType() == 5) continue;
            Date counttime = this.dateProcess(faceDataContent.getCountDate());
            String key = this.buildKey(counttime, faceDataContent.getChannelSerialnum());
            CountDataContent countDataContent = (CountDataContent)dataMap.get(key);
            if (countDataContent == null) {
                countDataContent = new CountDataContent();
                countDataContent.setVasid(faceDataContent.getVasId());
                countDataContent.setInnum(0);
                countDataContent.setOutnum(0);
                countDataContent.setChannelno(faceDataContent.getChannelSerialnum());
                countDataContent.setCreateTime(counttime);
                countDataContent.setStatus(Integer.valueOf(1));
                dataMap.put(key, countDataContent);
            }
            if (faceDataContent.getDirection() == 1) {
                countDataContent.setInnum(1 + countDataContent.getInnum());
            } else if (faceDataContent.getDirection() == -1) {
                countDataContent.setOutnum(1 + countDataContent.getOutnum());
            }
            this.logger.warn("\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u5f00\u59cb\u63d2\u5165\u5ba2\u6d41\u6570\u636e\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b");
            RedisUtil.addList((String)"countData", (Object)countDataContent);
        }
        this.logger.warn("\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u5f00\u59cb\u63d2\u5165\u5ba2\u6d41\u6570\u636e\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b\u300b");
    }

    private String buildKey(Date date, String channelSerialnum) {
        SimpleDateFormat sdf = (SimpleDateFormat)this.sdfThreadLocal.get();
        StringBuilder sb = new StringBuilder();
        sb.append(channelSerialnum).append(":").append(sdf.format(date));
        return sb.toString();
    }

    private Date dateProcess(Date date) {
        Date result = date;
        SimpleDateFormat sdf = (SimpleDateFormat)this.sdfThreadLocal.get();
        StringBuilder sb = new StringBuilder(sdf.format(date));
        sb.setLength(11);
        sb.append("959");
        try {
            result = sdf.parse(sb.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }
}

