/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.reader;

import java.util.ArrayList;
import java.util.Set;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;

public class RedisZSetPageReader<T>
extends AbstractPagingItemReader<ZSetOperations.TypedTuple<T>> {
    private RedisTemplate redisTemplate;
    private String key;
    private volatile double startScore = 0.0;

    public RedisZSetPageReader(RedisTemplate redisTemplate, String key, double startScore) {
        this.redisTemplate = redisTemplate;
        this.key = key;
        this.startScore = startScore;
    }

    protected void doReadPage() {
        double min = this.startScore + (double)(this.getPage() * this.getPageSize()) + 1.0;
        double max = min + (double)this.getPageSize() - 1.0;
        Set zSet = this.redisTemplate.boundZSetOps((Object)this.key).reverseRangeByScore(min, max);
        if (this.results == null) {
            this.results = new ArrayList();
        }
        this.results.clear();
        this.results.addAll(zSet);
    }

    protected void doJumpToPage(int itemIndex) {
    }
}

