/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.dao.StaffDao;
import com.viontech.keliu.dao.StaffFaceDao;
import com.viontech.keliu.exception.ParameterExceptin;
import com.viontech.keliu.model.BodyFeature;
import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.model.Data;
import com.viontech.keliu.model.FaceDataContent;
import com.viontech.keliu.model.FaceFeature;
import com.viontech.keliu.model.Feature;
import com.viontech.keliu.model.Mall;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.model.Staff;
import com.viontech.keliu.model.StaffFace;
import com.viontech.keliu.redis.RedisUtil;
import com.viontech.keliu.service.ConfigParamService;
import com.viontech.keliu.service.CreateFeaturePoolService;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.util.ConfigUtil;
import com.viontech.keliu.vo.websocket.Result;
import com.viontech.keliu.websocket.AlgApiClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import javax.websocket.DeploymentException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="staffRecognitionProcessor")
public class StaffRecognitionProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(StaffRecognitionProcessor.class);
    @Value(value="${ws.url:}")
    private String url;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired(required=false)
    private AlgApiClient algApiClientComparison;
    @Autowired
    private ObjectMapper objectMapper;
    @Resource
    private Storage featureStorage;
    @Value(value="${match.score.staff}")
    private Integer matchScoreStaff;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();
    @Resource
    private StaffDao staffDao;
    @Resource
    private StaffFaceDao staffFaceDao;
    @Resource
    private OrgCacheService orgCacheService;
    @Resource
    private ConfigParamService configParamService;
    @Resource
    private CreateFeaturePoolService createFeaturePoolService;

    public FaceDataContent process(FaceDataContent item) throws Exception {
        if (item.getMallId() == null) {
            this.logger.debug("\u8be5\u6761\u4eba\u8138\u6570\u636e\u7684mallId\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5e97\u5458\u6bd4\u5bf9\u529f\u80fd\uff01");
            return item;
        }
        Map configParamMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("ConfigMap");
        ConfigParam configParam = ConfigUtil.getConfigParam((Long)item.getMallId(), (Map)configParamMap);
        String staff = configParam.getStaff();
        if ("0".equals(staff)) {
            this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5173\u95ed\u5e97\u5458\u6bd4\u5bf9\u529f\u80fd,\u8df3\u8fc7\u5e97\u5458\u6bd4\u5bf9\u5904\u7406", (Object)item.getMallId());
            return item;
        }
        this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5f00\u542f\u5e97\u5458\u6bd4\u5bf9\u529f\u80fd,value\u4e3a{}", (Object)item.getMallId(), (Object)configParam.getStaff());
        if (this.algApiClientComparison == null) {
            return item;
        }
        this.logger.info("\u5f00\u59cb\u8fdb\u884c\u5e97\u5458\u5339\u914d");
        try {
            this.matchPerson(item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long end = System.currentTimeMillis();
        this.logger.info("\u5b8c\u6210\u5e97\u5458\u5339\u914d");
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        Map mallMap = this.orgCacheService.getMallMap();
        executionContext.put("mallMap", (Object)mallMap);
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("ConfigMap", (Object)configParamMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("ConfigMap", (Object)configParamMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("mallMap");
        executionContext.remove("ConfigMap");
        this.executionContextThreadLocal.remove();
    }

    private void createStaffPool(String poolName, FaceDataContent item) {
        try {
            JSONObject jsonObject = this.createFeaturePoolService.createFeaturePool(poolName);
            if (jsonObject == null) {
                this.logger.warn("\u7279\u5f81\u5e93:{}\u521b\u5efa\u5f02\u5e38", (Object)poolName);
                return;
            }
            if (jsonObject.getInt("errCode") == 20) {
                this.logger.warn("\u7279\u5f81\u5e93\uff1a{}\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u521b\u5efa\u589e\u52a0\u4eba\u5458\u6b65\u9aa4", (Object)poolName);
                return;
            }
            List staffs = this.staffDao.selectBySerialnum(item.getMallId());
            this.logger.info("****************\u6784\u5efa\u5e97\u5458\u6c60 \u5e97\u5458\u6570\u91cf\u4e3a**********:" + staffs.size());
            for (Staff staff : staffs) {
                ArrayList<Person> personPools = new ArrayList<Person>();
                List staffFaces = this.staffFaceDao.selectByStaffId(staff.getId());
                this.logger.debug("****************\u6784\u5efa\u5e97\u5458\u6c60 \u5e97\u5458{}\u4eba\u8138\u6570\u91cf\u4e3a{}**********:", (Object)staff.getId(), (Object)staffFaces.size());
                for (StaffFace staffFace : staffFaces) {
                    if (staffFace.getRecognitionId() == null) continue;
                    Person personPool = new Person();
                    personPool.setPersonId(staff.getPersonUnid());
                    ArrayList<FaceFeature> faceFeatures = new ArrayList<FaceFeature>();
                    String facePic = staffFace.getFacePic();
                    String[] split = facePic.split("/");
                    String picName = split[1] + "/" + split[2];
                    String json = (String)this.featureStorage.getItem(picName);
                    Feature feature = this.json2Feature(json);
                    if (feature == null) {
                        this.logger.debug("****************\u65e0\u6cd5\u83b7\u53d6\u5e97\u5458{}\u7684\u4eba\u8138{}**********:", (Object)staff.getId(), (Object)picName);
                        continue;
                    }
                    List datas = feature.getDatas();
                    if (datas != null && datas.size() > 0) {
                        for (Data data : datas) {
                            if (data.getType().equals("camera")) continue;
                            FaceFeature faceFeature = new FaceFeature();
                            BodyFeature bodyFeature = new BodyFeature();
                            if (picName.contains("face")) {
                                faceFeature.setFeature(data.getData());
                                faceFeature.setFid(picName + ".feature");
                            } else {
                                bodyFeature.setFeature(data.getData());
                                bodyFeature.setBid(picName + ".feature");
                            }
                            faceFeatures.add(faceFeature);
                            break;
                        }
                    }
                    personPool.setFaceFeatures(faceFeatures);
                    personPools.add(personPool);
                    this.algApiClientComparison.modifyPersonPool(poolName, 2, 2, personPools, new HashMap());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void matchPerson(FaceDataContent item) {
        Long mallId = item.getMallId();
        String facePic = item.getFaceFeature();
        if (facePic == null) {
            return;
        }
        List faceFeatures = this.getFaceFeatures(item.getChannelSerialnum(), facePic);
        if (faceFeatures == null || faceFeatures.isEmpty()) {
            return;
        }
        Person perosn = new Person();
        perosn.setPersonId(item.getPersonId());
        perosn.setFaceFeatures(faceFeatures);
        try {
            CompletableFuture responseFuture;
            JSONObject response;
            Result result;
            Object value = RedisUtil.getMapField((String)"featureStatus", (String)mallId.toString());
            if (value != null && "1".equals(value.toString())) {
                String poolName = this.getStaffName(item);
                this.logger.info("\u5e97\u5458\u53d1\u751f\u53d8\u5316\u5f00\u59cb\u6e05\u9664\u5546\u573a{}\u7684\u5e97\u5458\u7279\u5f81\u6c60\u4e3a:{}", (Object)mallId, (Object)poolName);
                CompletableFuture responseFuture2 = this.algApiClientComparison.delPersonPool(1, poolName, Collections.emptyList(), new HashMap());
                responseFuture2.get(120L, TimeUnit.SECONDS);
                RedisUtil.removeMapField((String)"featureStatus", (Object[])new Object[]{mallId.toString()});
            }
            if ((result = (Result)this.objectMapper.readValue((response = (JSONObject)(responseFuture = this.algApiClientComparison.matchPerson(2, perosn, this.getStaffName(item), Collections.emptyList(), new HashMap())).get(120L, TimeUnit.SECONDS)).toString(), Result.class)) == null) {
                return;
            }
            Integer match = result.getMatch();
            Integer errCode = result.getErrCode();
            if (match == 0 && errCode != null && errCode == 4) {
                this.logger.info("\u5f00\u59cb\u521b\u5efa\u5546\u573a{}\u7684\u5e97\u5458\u5e93", (Object)mallId);
                this.createStaffPool(this.getStaffName(item), item);
                this.logger.info("\u521b\u5efa\u5546\u573a{}\u5e97\u5458\u5e93\u5b8c\u6210", (Object)mallId);
                this.matchPerson(item);
                return;
            }
            if (result.getSuccess() == 0 || match == 0) {
                return;
            }
            List matchPersons = result.getMatchPersons();
            if (matchPersons == null) {
                return;
            }
            com.viontech.keliu.vo.websocket.Person personWs = (com.viontech.keliu.vo.websocket.Person)matchPersons.get(0);
            Double score = personWs.getScore();
            this.logger.info("\u5339\u914d\u7167\u7247:{},\u5339\u914d\u5206\u503c\u4e3a:", (Object)item.getFaceFeature(), (Object)score);
            if (score > (double)this.matchScoreStaff.intValue()) {
                item.setPersonId(personWs.getPersonId());
                item.setPersonType(Integer.valueOf(1));
            }
        }
        catch (DeploymentException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (ParameterExceptin parameterExceptin) {
            parameterExceptin.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
        }
        catch (TimeoutException e1) {
            e1.printStackTrace();
        }
    }

    private Feature json2Feature(String json) {
        Feature feature = null;
        if (json == null) {
            return null;
        }
        try {
            feature = (Feature)this.objectMapper.readValue(json, Feature.class);
        }
        catch (Exception e) {
            this.logger.error("\u65e0\u6cd5\u5c06json\u8f6c\u6210\u7279\u5f81\u5bf9\u8c61:" + json);
            e.printStackTrace();
        }
        return feature;
    }

    private String getStaffName(FaceDataContent item) {
        Map mallMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("mallMap");
        if (mallMap == null) {
            System.out.println();
        }
        Mall mall = (Mall)mallMap.get(item.getMallId().toString());
        String poolName = this.applicationName + "_staffPool_";
        poolName = mall != null ? poolName + mall.getUnid() : poolName + item.getMallId();
        return poolName;
    }

    private List<FaceFeature> getFaceFeatures(String channelSerialnum, String frrFacePictureExt) {
        ArrayList<FaceFeature> faceFeatures = new ArrayList<FaceFeature>();
        String[] facePicArr = frrFacePictureExt.split(",");
        for (int i = 0; i < facePicArr.length; ++i) {
            List datas;
            String picStr = facePicArr[i];
            String json = (String)this.featureStorage.getItem(channelSerialnum + "/" + picStr);
            Feature feature = this.json2Feature(json);
            if (feature == null) {
                this.logger.warn("{}\u6587\u4ef6\u7684\u7279\u5f81\u83b7\u53d6\u4e0d\u5230", (Object)picStr);
                continue;
            }
            Integer face_type = feature.getFace_type();
            if (face_type != null && face_type != 1 || (datas = feature.getDatas()) == null) continue;
            Data data = new Data();
            for (int j = 0; j < datas.size(); ++j) {
                Data data1 = (Data)datas.get(j);
                if (!"server".equals(data1.getType())) continue;
                data = data1;
                break;
            }
            if (data == null || "camera".equals(data.getType())) continue;
            FaceFeature faceFeature = new FaceFeature();
            faceFeature.setFid(picStr);
            faceFeature.setFeature(data.getData());
            faceFeatures.add(faceFeature);
        }
        return faceFeatures;
    }
}

