/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.model.FaceDataContent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.stereotype.Component;

@Component(value="repeatedFaceProcessor")
public class RepeatedFaceProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private Logger logger = LoggerFactory.getLogger(RepeatedFaceProcessor.class);
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("channelCaptureMap");
        this.executionContextThreadLocal.remove();
    }

    public FaceDataContent process(FaceDataContent item) throws Exception {
        ArrayList<FaceDataContent> list;
        this.logger.info("\u5f00\u59cb\u5904\u7406\u4eba\u5458\u53bb\u91cd");
        boolean repeated = false;
        String channelSerialnum = item.getChannelSerialnum();
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        HashMap channelCaptureMap = (HashMap)executionContext.get("channelCaptureMap");
        if (channelCaptureMap == null) {
            channelCaptureMap = new HashMap();
            executionContext.put("channelCaptureMap", channelCaptureMap);
        }
        if ((list = (ArrayList<FaceDataContent>)channelCaptureMap.get(channelSerialnum)) == null) {
            list = new ArrayList<FaceDataContent>();
            channelCaptureMap.put(channelSerialnum, list);
        }
        long time = item.getCountDate().getTime();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            FaceDataContent next = (FaceDataContent)iterator.next();
            Date pCountDate = next.getCountDate();
            if (Math.abs(pCountDate.getTime() - time) > 15000L) {
                iterator.remove();
                continue;
            }
            if (repeated || !next.getPersonId().equals(item.getPersonId())) continue;
            repeated = true;
        }
        this.logger.info("\u7ed3\u675f\u5904\u7406\u4eba\u5458\u53bb\u91cd");
        if (repeated) {
            return null;
        }
        list.add(item);
        return item;
    }
}

