/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import java.util.Date;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class OpenTimeProcessor<T>
implements ItemProcessor<T, T>,
ItemStream {
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private final String SQL_SEL_OPENTIME = "select mall_id,start_time,end_time,start_date,end_date,type,account_id,mall_id from b_mall_opentime";

    public T process(T item) throws Exception {
        if (this.isInBusiness(this.getMallId(item), this.getDate(item))) {
            this.doProcess(item);
        }
        return item;
    }

    public abstract T doProcess(T var1) throws Exception;

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
    }

    public void close() throws ItemStreamException {
        this.executionContextThreadLocal.remove();
    }

    private boolean isInBusiness(Long mallId, Date date) {
        return true;
    }

    protected abstract Long getMallId(T var1);

    protected abstract Date getDate(T var1);
}

