/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.dao.FaceRecognitionDao;
import com.viontech.keliu.model.BodyFeature;
import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.model.Data;
import com.viontech.keliu.model.FaceFeature;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.model.FaceRecognitionRecord;
import com.viontech.keliu.model.Feature;
import com.viontech.keliu.model.Mall;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.service.ConfigParamService;
import com.viontech.keliu.service.CreateFeaturePoolService;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.util.ConfigUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.vo.websocket.Result;
import com.viontech.keliu.websocket.AlgApiClient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Resource;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="newRegularCustomProcessor")
public class NewRegularCustomProcessor
implements ItemProcessor<FaceRecognition, FaceRecognition>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(NewRegularCustomProcessor.class);
    @Value(value="${ws.url:}")
    private String url;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired(required=false)
    private AlgApiClient algApiClientComparison;
    @Autowired
    private ObjectMapper objectMapper;
    @Resource
    private Storage featureStorage;
    @Value(value="${match.score.custom}")
    private Integer matchScoreCustom;
    @Resource
    private OrgCacheService orgCacheService;
    @Resource
    private ConfigParamService configParamService;
    @Autowired
    private FaceRecognitionDao faceRecognitionDao;
    @Resource
    private CreateFeaturePoolService createFeaturePoolService;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();

    public FaceRecognition process(FaceRecognition faceRecognition) throws Exception {
        if (faceRecognition.getMallId() == null) {
            this.logger.debug("\u8be5\u6761\u4eba\u8138\u6570\u636e\u7684mallId\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u65b0\u8001\u987e\u5ba2\u5904\u7406\uff01");
            return faceRecognition;
        }
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map configParamMap = (Map)executionContext.get("ConfigMap");
        ConfigParam configParam = ConfigUtil.getConfigParam((Long)faceRecognition.getMallId(), (Map)configParamMap);
        String newOrRegular = configParam.getNewOrRegular();
        if ("0".equals(newOrRegular)) {
            this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5173\u95ed\u65b0\u8001\u987e\u5ba2\u529f\u80fd,\u8df3\u8fc7\u65b0\u8001\u987e\u5ba2\u5904\u7406", (Object)faceRecognition.getMallId());
            faceRecognition.setStatus(Short.valueOf((short)1));
            faceRecognition.setHistoryArrivalCount(Short.valueOf((short)0));
            return faceRecognition;
        }
        this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5f00\u542f\u65b0\u8001\u987e\u5ba2\u529f\u80fd,value\u4e3a{}", (Object)faceRecognition.getMallId(), (Object)configParam.getNewOrRegular());
        this.logger.debug("\u65b0\u8001\u987e\u5ba2\u5904\u7406\u5f00\u59cb\uff01");
        faceRecognition.setStatus(Short.valueOf((short)1));
        faceRecognition.setHistoryArrivalCount(Short.valueOf((short)0));
        if (this.algApiClientComparison == null) {
            faceRecognition.setHistoryArrivalCount(Short.valueOf((short)0));
            return faceRecognition;
        }
        Map mallMap = (Map)executionContext.get("mallMap");
        List customNames = this.getCustomPoolNames(faceRecognition);
        Mall mall = (Mall)mallMap.get(faceRecognition.getMallId().toString());
        if (mall == null) {
            this.logger.error("mallId\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u5f53\u524d\u5904\u7406");
            return faceRecognition;
        }
        try {
            Result result = this.matchPerson(faceRecognition, customNames);
            this.logger.debug("\u65b0\u8001\u987e\u5ba2\u5339\u914d\u8fd4\u56de\u7ed3\u679c\uff1a" + this.objectMapper.writeValueAsString((Object)result));
            if (result == null) {
                this.logger.debug("\u65e0\u6cd5\u83b7\u53d6\u5230\u5339\u914d\u7ed3\u679c \u4e0d\u518d\u7ee7\u7eed\u5904\u7406");
                return faceRecognition;
            }
            Integer match = result.getMatch();
            Integer errCode = result.getErrCode();
            if ((match == null || match == 0) && errCode != null && errCode == 4) {
                this.logger.debug("\u65b0\u8001\u987e\u5ba2\u7279\u5f81\u6c60\u90fd\u4e0d\u5b58\u5728\u8fd4\u56de\u7ed3\u679c:" + this.objectMapper.writeValueAsString((Object)result));
                for (Object customName : customNames) {
                    this.createCustomMallDayPool((String)customName, faceRecognition);
                }
            }
            this.packAgePerson(faceRecognition, result);
            List personPoolStatus = result.getPersonPoolStatus();
            customNames.clear();
            for (com.viontech.keliu.vo.websocket.Person poolStatus : personPoolStatus) {
                Integer status = poolStatus.getStatus();
                String personPoolId = poolStatus.getPersonPoolId();
                if (status != 1) continue;
                this.logger.debug("\u65b0\u8001\u987e\u5ba2\u5339\u914d\u67d0\u4e00\u4e2a\u7279\u5f81\u6c60\u4e0d\u5b58\u5728\u8fd4\u56de\u7ed3\u679c:status:{},personPoolId:{}", (Object)status, (Object)personPoolId);
                this.createCustomMallDayPool(personPoolId, faceRecognition);
                customNames.add(personPoolId);
            }
            if (customNames.size() > 0) {
                result = this.matchPerson(faceRecognition, customNames);
                this.packAgePerson(faceRecognition, result);
                this.logger.debug("\u65b0\u8001\u987e\u5ba2\u7279\u5f81\u6c60\u90fd\u4e0d\u5b58\u5728\u8fd4\u56de\u7ed3\u679c(\u4e8c\u6b21\u5339\u914d):" + this.objectMapper.writeValueAsString((Object)result));
            }
            HashSet<String> onlySet = new HashSet<String>();
            ArrayList<FaceRecognitionRecord> frrListNew = new ArrayList<FaceRecognitionRecord>();
            List frrList = faceRecognition.getFaceRecognitionRecords();
            if (frrList != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                for (FaceRecognitionRecord frr : frrList) {
                    Date countdate = frr.getCountdate();
                    String personUnid = frr.getPersonUnid();
                    String dateStr = sdf.format(countdate);
                    if (!onlySet.add(personUnid + ":" + dateStr)) continue;
                    frrListNew.add(frr);
                }
            }
            if (frrListNew != null && frrListNew.size() > 0) {
                faceRecognition.setFaceRecognitionRecords(frrListNew);
                int frrSize = frrListNew.size();
                faceRecognition.setHistoryArrivalCount(Short.valueOf((short)frrSize));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return faceRecognition;
    }

    private void packAgePerson(FaceRecognition faceRecognition, Result result) {
        if (result != null) {
            List matchPersons;
            ArrayList<FaceRecognitionRecord> faceRecognitionRecords = faceRecognition.getFaceRecognitionRecords();
            if (faceRecognitionRecords == null) {
                faceRecognitionRecords = new ArrayList<FaceRecognitionRecord>();
            }
            if ((matchPersons = result.getMatchPersons()) != null) {
                for (com.viontech.keliu.vo.websocket.Person matchPerson : matchPersons) {
                    Double score = matchPerson.getScore();
                    if (score == null || !(score > (double)this.matchScoreCustom.intValue())) continue;
                    FaceRecognitionRecord faceRecognitionRecord = new FaceRecognitionRecord();
                    String personId = matchPerson.getPersonId();
                    String personPoolId = matchPerson.getPersonPoolId();
                    String[] personPoolSplits = personPoolId.split("_");
                    faceRecognitionRecord.setFaceRecognitionId(faceRecognition.getId());
                    faceRecognitionRecord.setFaceRecognitionUnid(faceRecognition.getUnid());
                    faceRecognitionRecord.setPersonUnid(personId);
                    Date date = new Date();
                    faceRecognitionRecord.setCreateTime(date);
                    faceRecognitionRecord.setModifyTime(date);
                    try {
                        faceRecognitionRecord.setCountdate(DateUtil.parse((String)DateUtil.FORMAT_SHORT, (String)personPoolSplits[2]));
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                    faceRecognitionRecords.add(faceRecognitionRecord);
                    faceRecognition.setFaceRecognitionRecords(faceRecognitionRecords);
                }
            }
        }
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map mallMap = this.orgCacheService.getMallMap();
        executionContext.put("mallMap", (Object)mallMap);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map mallMap = this.orgCacheService.getMallMap();
        executionContext.put("mallMap", (Object)mallMap);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("mallMap");
        executionContext.remove("mallMap");
        this.executionContextThreadLocal.remove();
    }

    private List<String> getCustomPoolNames(FaceRecognition item) {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        Map configParamMap = (Map)executionContext.get("configMap");
        ConfigParam configParam = ConfigUtil.getConfigParam((Long)item.getMallId(), (Map)configParamMap);
        Integer matchDays = Integer.parseInt(configParam.getNewOrRegular());
        this.logger.debug("\u83b7\u53d6\u65b0\u8001\u987e\u5ba2\u7279\u5f81\u6c60\u540d\u79f0\u5f00\u59cb");
        Map mallMap = (Map)executionContext.get("mallMap");
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 1; i <= matchDays; ++i) {
            String format = DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)DateUtil.addDays((Date)item.getCountdate(), (int)(-i)));
            Mall mall = (Mall)mallMap.get(item.getMallId().toString());
            if (mall != null) {
                names.add(this.applicationName + "_customPool_" + format + "_" + mall.getUnid());
                continue;
            }
            names.add(this.applicationName + "_customPool_" + format + "_" + item.getMallId());
        }
        this.logger.debug("\u83b7\u53d6\u7279\u5f81\u6c60\u540d\u79f0\u7ed3\u675f");
        return names;
    }

    private Result matchPerson(FaceRecognition item, List<String> customNames) {
        this.logger.debug("\u65b0\u8001\u987e\u5ba2\u5339\u914d\u4eba\u5458\u4fe1\u606f\u5f00\u59cb");
        String facePic = item.getFaceFeature();
        if (facePic == null) {
            return null;
        }
        List faceFeatures = this.getFaceFeatures(item.getChannelSerialnum(), facePic);
        if (faceFeatures == null || faceFeatures.isEmpty()) {
            return null;
        }
        Person person = new Person();
        person.setPersonId(item.getPersonUnid());
        person.setFaceFeatures(faceFeatures);
        AtomicReference<Result> result = new AtomicReference<Result>(new Result());
        try {
            CompletableFuture responseFuture = this.algApiClientComparison.matchHistoryPerson(2, person, customNames, new HashMap());
            JSONObject response = (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
            Result resultNew = (Result)this.objectMapper.readValue(response.toString(), Result.class);
            result.set(resultNew);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.debug("\u65b0\u8001\u987e\u5ba2\u5339\u914d\u4eba\u5458\u4fe1\u606f\u7ed3\u675f");
        return result.get();
    }

    private Feature json2Feature(String json) {
        if (json == null) {
            this.logger.warn(json);
        }
        Feature feature = null;
        try {
            feature = (Feature)this.objectMapper.readValue(json, Feature.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return feature;
    }

    private List<FaceFeature> getFaceFeatures(String channelSerialnum, String frrFacePictureExt) {
        long ss = System.currentTimeMillis();
        ArrayList<FaceFeature> faceFeatures = new ArrayList<FaceFeature>();
        String[] facePicArr = frrFacePictureExt.split(",");
        for (int i = 0; i < facePicArr.length; ++i) {
            String picStr = facePicArr[i];
            String json = (String)this.featureStorage.getItem(channelSerialnum + "/" + picStr);
            if (json == null) continue;
            Feature feature = this.json2Feature(json);
            if (feature == null) {
                this.logger.warn("{}\u6587\u4ef6\u7684\u7279\u5f81\u83b7\u53d6\u4e0d\u5230", (Object)picStr);
                continue;
            }
            List datas = feature.getDatas();
            if (datas == null) continue;
            Data data = new Data();
            Integer face_type = feature.getFace_type();
            if (face_type != null && face_type != 1) continue;
            for (int j = 0; j < datas.size(); ++j) {
                Data data1 = (Data)datas.get(j);
                if (!data1.getType().equals("server")) continue;
                data = data1;
                break;
            }
            if (data == null || data.getType() == null || data.getType().equals("camera")) continue;
            FaceFeature faceFeature = new FaceFeature();
            faceFeature.setFid(picStr);
            faceFeature.setFeature(data.getData());
            faceFeatures.add(faceFeature);
        }
        long end = System.currentTimeMillis();
        this.logger.debug("*********getFaceFeatures:" + (end - ss));
        return faceFeatures;
    }

    private void createCustomMallDayPool(String poolName, FaceRecognition item) {
        try {
            JSONObject response = this.createFeaturePoolService.createFeaturePool(poolName);
            if (response == null) {
                this.logger.warn("\u7279\u5f81\u5e93:{}\u521b\u5efa\u5f02\u5e38", (Object)poolName);
            } else if (response.getInt("errCode") == 20) {
                this.logger.info("\u7279\u5f81\u5e93\uff1a{}\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u521b\u5efa\u589e\u52a0\u4eba\u5458\u6b65\u9aa4", (Object)poolName);
            } else {
                Long mallId = item.getMallId();
                String[] poolInfos = poolName.split("_");
                Date poolDate = DateUtil.parse((String)DateUtil.FORMAT_SHORT, (String)poolInfos[2]);
                List faceRecognitions = this.faceRecognitionDao.selectByCountDateAndMallId(poolDate, mallId);
                this.logger.info("\u521b\u5efa\u7279\u5f81\u5e93\uff1a{},\u67e5\u8be2\u65e5\u671f:{},\u5e7f\u573aid:{},\u67e5\u8be2\u6761\u76ee\u6570:{}", new Object[]{poolName, DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)poolDate), mallId, faceRecognitions == null ? null : Integer.valueOf(faceRecognitions.size())});
                int count = 0;
                for (FaceRecognition faceRecognition : faceRecognitions) {
                    Feature feature;
                    long startTime = System.currentTimeMillis();
                    ArrayList<Person> personPools = new ArrayList<Person>();
                    Person personPool = new Person();
                    personPool.setPersonId(faceRecognition.getPersonUnid());
                    ArrayList<FaceFeature> faceFeatures = new ArrayList<FaceFeature>();
                    String featureName = faceRecognition.getFaceFeature();
                    if (featureName == null) {
                        this.logger.debug("faceFeature\u4e3a\u7a7a\u5f02\u5e38\u8df3\u8fc7,id\u4e3a:{}", (Object)faceRecognition.getId());
                        continue;
                    }
                    String json = (String)this.featureStorage.getItem(faceRecognition.getChannelSerialnum() + "/" + featureName);
                    if (json == null || (feature = this.json2Feature(json)) == null) continue;
                    List datas = feature.getDatas();
                    Integer face_type = feature.getFace_type();
                    if (face_type != null && face_type != 1) continue;
                    if (datas != null && datas.size() > 0) {
                        for (Data data : datas) {
                            if (data.getType().equals("camera")) continue;
                            FaceFeature faceFeature = new FaceFeature();
                            BodyFeature bodyFeature = new BodyFeature();
                            if (featureName.contains("face")) {
                                faceFeature.setFeature(data.getData());
                                faceFeature.setFid(featureName + ".feature");
                            } else {
                                bodyFeature.setFeature(data.getData());
                                bodyFeature.setBid(featureName + ".feature");
                            }
                            faceFeatures.add(faceFeature);
                            break;
                        }
                    }
                    ++count;
                    personPool.setFaceFeatures(faceFeatures);
                    personPools.add(personPool);
                    CompletableFuture resultFuture = this.algApiClientComparison.modifyPersonPool(poolName, 2, 2, personPools, new HashMap());
                    long endTime = System.currentTimeMillis();
                    if (endTime - startTime <= 0L) continue;
                    this.logger.debug("\u5411\u7279\u5f81\u5e93:{} \u589e\u52a0\u4eba\u5458id\u4e3a:{} \u8017\u65f6:{}", new Object[]{poolName, faceRecognition.getId(), endTime - startTime});
                }
                this.logger.warn("\u5411\u8fd9\u4e2a\u7279\u5f81\u5e93{}\u4e2d\u589e\u52a0:{}\u4eba", (Object)poolName, (Object)count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

