/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.model.GateCountData;
import com.viontech.keliu.util.DateUtil;
import java.util.Date;
import java.util.Map;
import org.springframework.batch.item.ItemProcessor;

public class GateCountDataProcessor
implements ItemProcessor<Map, GateCountData> {
    private int mallDayTimeOffset;

    public GateCountDataProcessor(int mallDayTimeOffset) {
        this.mallDayTimeOffset = mallDayTimeOffset;
    }

    public GateCountData process(Map item) throws Exception {
        Long gateId = (Long)item.get("gateId");
        if (gateId == null) {
            return null;
        }
        Long mallId = (Long)item.get("mallId");
        if (mallId == null) {
            return null;
        }
        Long accountId = (Long)item.get("accountId");
        if (accountId == null) {
            return null;
        }
        Integer innum = 0;
        try {
            innum = Integer.parseInt(item.get("innum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Integer outnum = 0;
        try {
            outnum = Integer.parseInt(item.get("outnum").toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date createTime = (Date)item.get("createTime");
        if (createTime == null) {
            return null;
        }
        GateCountData gateCountData = new GateCountData();
        gateCountData.setInnum(innum.intValue());
        gateCountData.setOutnum(outnum.intValue());
        gateCountData.setAccountId(accountId.longValue());
        gateCountData.setMallId(mallId.longValue());
        gateCountData.setGateId(gateId.longValue());
        gateCountData.setCountDate(DateUtil.addHours((Date)createTime, (int)this.mallDayTimeOffset));
        gateCountData.setCountTime(createTime);
        return gateCountData;
    }
}

