/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.model.Data;
import com.viontech.keliu.model.FaceDataContent;
import com.viontech.keliu.model.Feature;
import com.viontech.keliu.service.ConfigParamService;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.util.ConfigUtil;
import com.viontech.keliu.vo.websocket.FaceFeature;
import com.viontech.keliu.vo.websocket.Result;
import com.viontech.keliu.websocket.AlgApiClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Encoder;

@Component(value="featureExtractProcessor")
public class FeatureExtractProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(FeatureExtractProcessor.class);
    @Resource
    private Storage imageStorage;
    @Resource
    private Storage featureStorage;
    @Resource
    private ConfigParamService configParamService;
    @Value(value="${ws.featureUrl:}")
    private String url;
    @Autowired(required=false)
    private AlgApiClient algApiClientFeature;
    @Autowired
    private ObjectMapper objectMapper;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();
    BASE64Encoder base64Encoder = new /* Unavailable Anonymous Inner Class!! */;

    private String transformFeatureConfig(String featureConfig, boolean isNotNone) {
        switch (featureConfig) {
            case "0": {
                if (isNotNone) {
                    return "all";
                }
                return "none";
            }
            case "1": {
                return "one";
            }
            case "2": {
                return "all";
            }
        }
        return featureConfig;
    }

    private List<String> getNeedExtractPic(FaceDataContent item) {
        ArrayList<String> pictures = new ArrayList<String>();
        Map configParamMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("configMap");
        ConfigParam configParam = ConfigUtil.getConfigParam((Long)item.getMallId(), (Map)configParamMap);
        String faceFeatureConfig = configParam.getFaceFeature();
        String bodyFeatureConfig = configParam.getBodyFeature();
        boolean faceIsNotNone = "1".equals(configParam.getCalibrate()) || "1".equals(configParam.getCustom()) || "1".equals(configParam.getStaff()) || "1".equals(configParam.getNewOrRegular());
        faceFeatureConfig = this.transformFeatureConfig(faceFeatureConfig, faceIsNotNone);
        boolean bodyIsNotNone = "1".equals(configParam.getReid());
        if ("none".equals(bodyFeatureConfig = this.transformFeatureConfig(bodyFeatureConfig, bodyIsNotNone)) && "none".equals(faceFeatureConfig)) {
            return pictures;
        }
        if (!"none".equals(bodyFeatureConfig)) {
            String[] bodyImageNames;
            for (String bodyImage : bodyImageNames = item.getBodyImageName()) {
                if (bodyImage == null || "".equals(bodyImage.trim()) || bodyImage.contains("null")) continue;
                pictures.add(bodyImage.trim());
                if ("one".equals(bodyFeatureConfig)) break;
            }
        }
        String[] faceImageName = item.getFaceImageName();
        if (!"none".equals(faceFeatureConfig)) {
            for (String faceImage : faceImageName) {
                if (faceImage == null || "".equals(faceImage.trim()) || faceImage.contains("null")) continue;
                pictures.add(faceImage.trim());
                if ("one".equals(faceFeatureConfig)) break;
            }
        }
        return pictures;
    }

    /*
     * Unable to fully structure code
     */
    public FaceDataContent process(FaceDataContent item) throws Exception {
        if (this.algApiClientFeature == null) {
            return item;
        }
        if (item.getMallId() == null) {
            this.logger.debug("\u8be5\u6761\u4eba\u8138\u6570\u636e\u7684mallId\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u7279\u5f81\u63d0\u53d6\u529f\u80fd\uff01");
            return item;
        }
        item.setPersonType(Integer.valueOf(0));
        item.setFaceFeature(null);
        iamges = new ArrayList<String>();
        faceKeys = new ArrayList<List>();
        needExtractPic = this.getNeedExtractPic(item);
        for (String picture : needExtractPic) {
            featureStr = (String)this.featureStorage.getItem(item.getChannelSerialnum() + "/" + picture);
            if (featureStr == null || featureStr.trim().isEmpty()) {
                this.logger.info("{}\u7684\u7279\u5f81\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u8005\u5185\u5bb9\u4e3aEmpty", (Object)picture);
                continue;
            }
            try {
                feature = (Feature)this.objectMapper.readValue(featureStr, Feature.class);
                if (feature == null) {
                    this.logger.info("{}\u7684\u7279\u5f81\u6587\u4ef6\u8f6c\u6362\u4e0d\u6210Feature model\u9519\u8bef", (Object)picture);
                    continue;
                }
                type = feature.getType();
                face_type = feature.getFace_type();
                if (type != null) {
                    if (type.equals("face") && face_type != null && face_type != 1) {
                        this.logger.info("{}--\u8d28\u91cf\u4e0d\u597d\u7684\u7167\u7247\u8df3\u8fc7\u63d0\u53d6\u7279\u5f81,type:{},face_type:{}", new Object[]{picture, type, face_type});
                        continue;
                    }
                }
                if ((faceFeatureInfo = item.getFaceFeature()) == null && type != null) {
                    if (type.equals("face") && face_type == 1) {
                        item.setFaceFeature(picture);
                        item.setFace_score(feature.getFace_score());
                        item.setFace_type(face_type);
                    }
                }
                dataInfo = feature.getDatas();
                haveServerFeature = false;
                if (dataInfo != null) {
                    for (Data data : dataInfo) {
                        if (!"server".equals(data.getType().trim())) continue;
                        haveServerFeature = true;
                    }
                }
                if (haveServerFeature.booleanValue()) continue;
                byteArrayItem = this.imageStorage.getByteArrayItem(item.getChannelSerialnum() + "/" + picture);
                if (byteArrayItem == null) {
                    this.logger.warn("{}\u4e0d\u5b58\u5728\u6216\u8005\u5185\u5bb9\u4e3a\u7a7a", (Object)picture);
                    continue;
                }
                image = this.base64Encoder.encode(byteArrayItem);
                options = new HashMap<String, E>();
                if (type == null) ** GOTO lbl-1000
                if (type.equals("body")) {
                    options.put("body_roi", feature.getBody_roi().get(0));
                } else lbl-1000:
                // 2 sources

                {
                    type = "face";
                    key_point = feature.getKey_point();
                    if (key_point != null) {
                        iamges.add(image);
                        faceKeys.add(key_point);
                    }
                }
                responseFuture = this.algApiClientFeature.getFeatureAndAttr(image, type, "jpg", feature.getKey_point(), options);
                response = (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
                gender = response.getString("gender");
                age = response.getInt("age");
                faceFeature = null;
                if (response.keySet().contains("faceFeature")) {
                    faceFeature = response.getJSONObject("faceFeature");
                }
                bodyFeature = null;
                if (response.keySet().contains("bodyFeature")) {
                    bodyFeature = response.getJSONObject("bodyFeature");
                }
                featureJsonObject = null;
                if (faceFeature != null) {
                    featureJsonObject = faceFeature;
                } else if (bodyFeature != null) {
                    featureJsonObject = bodyFeature;
                }
                datas = feature.getDatas();
                if (datas == null) {
                    datas = new ArrayList<Data>();
                    feature.setDatas(datas);
                }
                data = new Data();
                data.setType("server");
                data.setData(featureJsonObject.getJSONArray("feature").toList().toArray(new Double[0]));
                datas.add(data);
                json = this.objectMapper.writeValueAsString((Object)feature);
                this.featureStorage.setItem(item.getChannelSerialnum() + "/" + picture, (Object)json);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (iamges.size() > 1) {
            responseFuture = this.algApiClientFeature.getFaceFeatureBatch(iamges, "jpg", faceKeys, Collections.emptyList());
            faceFeature = null;
            try {
                response = (JSONObject)responseFuture.get(120L, TimeUnit.SECONDS);
                result = (Result)this.objectMapper.readValue(response.toString(), Result.class);
                faceFeatureArr = result.getFaceFeatureArr();
                if (faceFeatureArr != null && faceFeatureArr.size() > 0) {
                    faceFeature = (FaceFeature)faceFeatureArr.get(faceFeatureArr.size() - 1);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            if (faceFeature != null) {
                facePic = item.getFacePic();
                faceNameSubStr = facePic.substring(0, facePic.length() - 5);
                faceNameF = faceNameSubStr + "F.jpg";
                feature = new Feature();
                feature.setFilename(faceNameF);
                feature.setType("face");
                feature.setFace_type(1);
                datas = new ArrayList<Data>();
                data = new Data();
                data.setType("server");
                featureList = faceFeature.getFeature();
                objects = new Object[]{};
                doubles = new Double[]{};
                if (featureList != null && featureList.size() > 0) {
                    objects = featureList.toArray();
                    doubles = new Double[featureList.size()];
                }
                for (i = 0; i < objects.length; ++i) {
                    doubles[i] = Double.parseDouble(String.valueOf(objects[i]));
                }
                data.setData(doubles);
                datas.add(data);
                feature.setDatas(datas);
                if (doubles != null && doubles.length > 0) {
                    json = null;
                    try {
                        json = this.objectMapper.writeValueAsString((Object)feature);
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                    this.featureStorage.setItem(item.getChannelSerialnum() + "/" + faceNameF, (Object)json);
                    item.setFaceFeature(faceNameF);
                }
            }
        }
        if (item.getFaceFeature() == null) {
            item.setFaceFeature(item.getFacePic());
        }
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("configMap");
        this.executionContextThreadLocal.remove();
    }
}

