/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.batch.item.stream.BussinessValidItemStream;
import com.viontech.keliu.dao.ChannelDao;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.FaceDataContent;
import com.viontech.keliu.service.OrgCacheService;
import java.util.Date;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="faceDataOrgProcessor")
public class FaceDataOrgProcessor
extends BussinessValidItemStream<FaceDataContent>
implements ItemProcessor<FaceDataContent, FaceDataContent> {
    private Logger logger = LoggerFactory.getLogger(FaceDataOrgProcessor.class);
    @Autowired
    private ChannelDao channelDao;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private OrgCacheService orgCacheService;

    public FaceDataContent process(FaceDataContent item) throws Exception {
        item.setUnid(item.getPersonId());
        item.setHistoryArrivalCount(Integer.valueOf(0));
        this.logger.debug("\u5f00\u59cb\u5904\u7406\u4eba\u8138\u6570\u636e\u7684\u7ec4\u7ec7\u673a\u6784\u5173\u7cfb");
        Map channelMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("channelMap");
        Channel channel = (Channel)channelMap.get(item.getChannelSerialnum());
        if (channel == null) {
            channel = this.channelDao.selectBySerialnum(item.getChannelSerialnum());
        }
        if (channel != null) {
            if (channel.getAccountId() == null) {
                this.logger.warn("\u8bbe\u5907\u901a\u9053{}\u7684AccountId\u4e0d\u5b58\u5728", (Object)item.getChannelSerialnum());
                return null;
            }
            item.setAccountId(channel.getAccountId());
            if (channel.getMallId() == null) {
                this.logger.warn("\u8bbe\u5907\u901a\u9053{}\u7684MallId\u4e0d\u5b58\u5728", (Object)item.getChannelSerialnum());
                return null;
            }
            item.setMallId(channel.getMallId());
            item.setChannelId(channel.getId());
            if (channel.getDeviceId() == null) {
                this.logger.warn("\u8bbe\u5907\u901a\u9053{}\u7684DeviceId\u4e0d\u5b58\u5728", (Object)item.getChannelSerialnum());
                return null;
            }
            item.setDeviceId(channel.getDeviceId());
            if (channel.getGateId() == null) {
                this.logger.warn("\u8bbe\u5907\u901a\u9053{}\u7684GateId\u4e0d\u5b58\u5728", (Object)item.getChannelSerialnum());
                return null;
            }
            item.setGateId(channel.getGateId());
            if (!this.isValid((Object)item)) {
                return null;
            }
            return item;
        }
        this.logger.warn("\u8bbe\u5907\u901a\u9053{}\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u8be5\u901a\u9053", (Object)item.getChannelSerialnum());
        this.logger.info("\u7ed3\u675f\u5904\u7406\u4eba\u8138\u6570\u636e\u7684\u7ec4\u7ec7\u673a\u6784\u5173\u7cfb");
        return null;
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        super.open(executionContext);
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("channelMap");
        super.close();
    }

    protected Date getCounttime(FaceDataContent faceDataContent) {
        return faceDataContent.getCountDate();
    }

    protected Long getMallId(FaceDataContent faceDataContent) {
        return faceDataContent.getMallId();
    }
}

