/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.dao.FaceRecognitionDao;
import com.viontech.keliu.model.BodyFeature;
import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.model.Data;
import com.viontech.keliu.model.FaceDataContent;
import com.viontech.keliu.model.FaceFeature;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.model.Feature;
import com.viontech.keliu.model.Mall;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.service.ConfigParamService;
import com.viontech.keliu.service.CreateFeaturePoolService;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.util.ConfigUtil;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.vo.websocket.Result;
import com.viontech.keliu.websocket.AlgApiClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="customRecognitionProcessor")
public class CustomRecognitionProcessor
implements ItemProcessor<FaceDataContent, FaceDataContent>,
ItemStream {
    private final Logger logger = LoggerFactory.getLogger(CustomRecognitionProcessor.class);
    @Value(value="${ws.url:}")
    private String url;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired(required=false)
    private AlgApiClient algApiClientComparison;
    @Autowired
    private ObjectMapper objectMapper;
    @Resource
    private Storage featureStorage;
    @Value(value="${match.score.custom}")
    private Integer matchScoreCustom;
    @Resource
    private FaceRecognitionDao faceRecognitionDao;
    @Resource
    private OrgCacheService orgCacheService;
    @Resource
    private ConfigParamService configParamService;
    @Resource
    private CreateFeaturePoolService createFeaturePoolService;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();

    public CustomRecognitionProcessor() {
        this.logger.info("\u521b\u5efaCustomRecognitionProcessor");
    }

    public FaceDataContent process(FaceDataContent item) throws Exception {
        try {
            if (item.getMallId() == null) {
                this.logger.debug("\u8be5\u6761\u4eba\u8138\u6570\u636e\u7684mallId\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u987e\u5ba2\u6bd4\u5bf9\u529f\u80fd\uff01");
                return item;
            }
            String facePic = item.getFaceFeature();
            if (facePic == null) {
                return item;
            }
            Integer frrType = item.getPersonType();
            if (frrType != null && frrType == 1) {
                return item;
            }
            item.setPersonType(Integer.valueOf(0));
            Map configParamMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("configMap");
            ConfigParam configParam = ConfigUtil.getConfigParam((Long)item.getMallId(), (Map)configParamMap);
            String custom = configParam.getCustom();
            if ("0".equals(custom)) {
                this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5173\u95ed\u987e\u5ba2\u6bd4\u5bf9\u529f\u80fd,\u8df3\u8fc7\u987e\u5ba2\u6bd4\u5bf9\u5904\u7406", (Object)item.getMallId());
                return item;
            }
            this.logger.debug("\u5546\u573aid\u4e3a{}\u7684\u5546\u573a\u5f00\u542f\u987e\u5ba2\u6bd4\u5bf9\u529f\u80fd,value\u4e3a{}", (Object)item.getMallId(), (Object)configParam.getCustom());
            if (this.algApiClientComparison == null) {
                return item;
            }
            this.matchPerson(item);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map mallMap = this.orgCacheService.getMallMap();
        executionContext.put("mallMap", (Object)mallMap);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map configParamMap = this.configParamService.selectAll();
        executionContext.put("configMap", (Object)configParamMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("mallMap");
        executionContext.remove("configMap");
        this.executionContextThreadLocal.remove();
    }

    private void createCustomPool(String poolName, FaceDataContent item) {
        long start = System.currentTimeMillis();
        try {
            JSONObject jsonObject = this.createFeaturePoolService.createFeaturePool(poolName);
            if (jsonObject == null) {
                this.logger.warn("\u7279\u5f81\u5e93:{}\u521b\u5efa\u5f02\u5e38", (Object)poolName);
                return;
            }
            if (jsonObject.getInt("errCode") == 20) {
                this.logger.warn("\u7279\u5f81\u5e93\uff1a{}\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7\u521b\u5efa\u589e\u52a0\u4eba\u5458\u6b65\u9aa4", (Object)poolName);
                return;
            }
            this.logger.info("\u5f00\u59cb\u586b\u5145\u5f53\u65e5\u987e\u5ba2\u5e93:{}", (Object)poolName);
            List faceRecognitions = this.faceRecognitionDao.selectByParameter(item.getMallId(), item.getCountDate(), Integer.valueOf(0));
            int faceCount = 0;
            if (faceRecognitions != null && faceRecognitions.size() > 0) {
                faceCount = faceRecognitions.size();
            }
            this.logger.info("\u5f00\u59cb\u586b\u5145\u5f53\u65e5\u987e\u5ba2\u5e93:{},\u9884\u8ba1\u586b\u5145\u6761\u6570:{}", (Object)poolName, (Object)faceCount);
            int count = 0;
            for (FaceRecognition faceRecognition : faceRecognitions) {
                this.logger.debug("\u5f00\u59cb\u586b\u5145\u7b2c{}\u6761", (Object)count);
                ArrayList<Person> personPools = new ArrayList<Person>();
                Person personPool = new Person();
                personPool.setPersonId(faceRecognition.getPersonUnid());
                ArrayList<FaceFeature> faceFeatures = new ArrayList<FaceFeature>();
                ArrayList<BodyFeature> bodyFeatures = new ArrayList<BodyFeature>();
                String facePic = faceRecognition.getFaceFeature();
                if (facePic == null) {
                    this.logger.debug("\u521b\u5efa\u987e\u5ba2\u5e93-faceFeature\u4e3a\u7a7a\u5f02\u5e38\u8df3\u8fc7,id\u4e3a:{}", (Object)faceRecognition.getId());
                    continue;
                }
                String[] split = facePic.split(",");
                block3: for (int i = 0; i < split.length; ++i) {
                    String picName = split[i];
                    String json = (String)this.featureStorage.getItem(faceRecognition.getChannelSerialnum() + "/" + picName);
                    if (json == null) {
                        this.logger.debug("\u521b\u5efa\u987e\u5ba2\u5e93-\u8bfb\u53d6json\u6587\u4ef6\u5f02\u5e38\u8df3\u8fc7,id\u4e3a:{}", (Object)faceRecognition.getId());
                        continue;
                    }
                    Feature feature = this.json2Feature(json);
                    if (feature == null) {
                        this.logger.debug("\u521b\u5efa\u987e\u5ba2\u5e93-\u6620\u5c04feature\u5f02\u5e38\u8df3\u8fc7,id\u4e3a:{}", (Object)faceRecognition.getId());
                        continue;
                    }
                    List datas = feature.getDatas();
                    Integer face_type = feature.getFace_type();
                    if (face_type != null && face_type != 1) {
                        this.logger.debug("\u521b\u5efa\u987e\u5ba2\u5e93-face_type\u4e3a\uff1a{}\u5f02\u5e38\u8df3\u8fc7,id\u4e3a:{}", (Object)face_type, (Object)faceRecognition.getId());
                        continue;
                    }
                    if (datas == null || datas.size() <= 0) {
                        this.logger.debug("\u521b\u5efa\u987e\u5ba2\u5e93-datas\u5f02\u5e38\u8df3\u8fc7,id\u4e3a:{}", (Object)faceRecognition.getId());
                        continue;
                    }
                    for (Data data : datas) {
                        if (data.getType().equals("camera")) continue;
                        FaceFeature faceFeature = new FaceFeature();
                        BodyFeature bodyFeature = new BodyFeature();
                        if (picName.contains("face")) {
                            faceFeature.setFeature(data.getData());
                            faceFeature.setFid(picName + ".feature");
                        } else {
                            bodyFeature.setFeature(data.getData());
                            bodyFeature.setBid(picName + ".feature");
                        }
                        faceFeatures.add(faceFeature);
                        bodyFeatures.add(bodyFeature);
                        continue block3;
                    }
                }
                if (faceFeatures == null || faceFeatures.size() <= 0) {
                    this.logger.debug("\u521b\u5efa\u987e\u5ba2\u5e93-faceFeatures\u4e3a\u7a7a\u5f02\u5e38\u8df3\u8fc7,id\u4e3a:{}", (Object)faceRecognition.getId());
                    continue;
                }
                personPool.setFaceFeatures(faceFeatures);
                personPool.setBodyFeatures(bodyFeatures);
                personPools.add(personPool);
                CompletableFuture resultFuture = this.algApiClientComparison.modifyPersonPool(poolName, 2, 2, personPools, new HashMap());
                JSONObject resultJson = (JSONObject)resultFuture.get(60L, TimeUnit.SECONDS);
                this.logger.debug("\u521b\u5efa\u987e\u5ba2\u5e93-\u5411:{}\u589e\u52a0id\u4e3a:{}", (Object)poolName, (Object)faceRecognition.getId());
                ++count;
            }
            this.logger.info("\u521b\u5efa\u987e\u5ba2\u4eba\u8138\u5e93:{} \u5b8c\u6210\uff0c\u8017\u65f6:{}\u6dfb\u52a0\u4eba\u6570\uff1a{}\u67e5\u8be2\u51fa\u7684\u987e\u5ba2\u4eba\u6570:{}", new Object[]{poolName, System.currentTimeMillis() - start, count, faceCount});
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efa\u987e\u5ba2\u6c60\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
    }

    private void matchPerson(FaceDataContent item) {
        long start = System.currentTimeMillis();
        String facePic = item.getFaceFeature();
        if (facePic == null) {
            return;
        }
        List faceFeatures = this.getFaceFeatures(item.getChannelSerialnum(), facePic);
        if (faceFeatures == null || faceFeatures.isEmpty()) {
            this.logger.warn("***{}\u901a\u9053\uff0c{}\u7167\u7247\u7279\u5f81\u83b7\u53d6\u5931\u8d25", (Object)item.getChannelSerialnum(), (Object)facePic);
            return;
        }
        Person person = new Person();
        person.setPersonId(item.getPersonId());
        person.setFaceFeatures(faceFeatures);
        try {
            CompletableFuture responseFuture = this.algApiClientComparison.matchPerson(2, person, this.getCustomName(item), Collections.emptyList(), new HashMap());
            JSONObject response = (JSONObject)responseFuture.get(60L, TimeUnit.SECONDS);
            Result result = (Result)this.objectMapper.readValue(response.toString(), Result.class);
            if (result == null) {
                return;
            }
            Integer match = result.getMatch();
            Integer errCode = result.getErrCode();
            if (match == 0 && errCode != null && errCode == 4) {
                this.createCustomPool(this.getCustomName(item), item);
                this.matchPerson(item);
                return;
            }
            if (result.getSuccess() == 0 || match == 0) {
                this.modifyPersonPool(item, this.getCustomName(item));
                return;
            }
            List matchPersons = result.getMatchPersons();
            if (matchPersons == null) {
                this.modifyPersonPool(item, this.getCustomName(item));
                return;
            }
            com.viontech.keliu.vo.websocket.Person personWs = (com.viontech.keliu.vo.websocket.Person)matchPersons.get(0);
            Double score = personWs.getScore();
            if (score > (double)this.matchScoreCustom.intValue()) {
                this.logger.debug("\u5339\u914d\u5f97\u5206:{},\u539f\u59cbunid\u4e3a:{},\u5339\u914d\u5230\u7684unid\u4e3a:{}", new Object[]{score, item.getUnid(), personWs.getPersonId()});
                item.setPersonId(personWs.getPersonId());
                item.setPersonType(Integer.valueOf(0));
                return;
            }
            this.modifyPersonPool(item, this.getCustomName(item));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.debug("\u5b8c\u6210\u4eba\u8138\u5339\u914d,\u8017\u65f6:{}", (Object)(System.currentTimeMillis() - start));
    }

    private Feature json2Feature(String json) {
        if (json == null) {
            this.logger.warn(json);
        }
        Feature feature = null;
        try {
            feature = (Feature)this.objectMapper.readValue(json, Feature.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return feature;
    }

    private void modifyPersonPool(FaceDataContent item, String poolName) {
        long start = System.currentTimeMillis();
        ArrayList<Person> peoples = new ArrayList<Person>();
        String facePic = item.getFaceFeature();
        Person person = new Person();
        List faceFeatures = this.getFaceFeatures(item.getChannelSerialnum(), facePic);
        person.setPersonId(item.getPersonId());
        person.setFaceFeatures(faceFeatures);
        ArrayList bodyFeatures = new ArrayList();
        person.setBodyFeatures(bodyFeatures);
        peoples.add(person);
        try {
            this.algApiClientComparison.modifyPersonPool(poolName, 2, 2, peoples, new HashMap());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.debug("\u5f80\u987e\u5ba2\u4eba\u8138\u5e93:{}\u4e2d\u8ffd\u52a0\u4eba\u8138,\u8017\u65f6:{}", (Object)poolName, (Object)(System.currentTimeMillis() - start));
    }

    private String getCustomName(FaceDataContent item) {
        Map mallMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("mallMap");
        String format = DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)item.getCountDate());
        Mall mall = (Mall)mallMap.get(item.getMallId().toString());
        String poolName = this.applicationName + "_customPool_" + format + "_";
        poolName = mall != null ? poolName + mall.getUnid() : poolName + item.getMallId();
        return poolName;
    }

    private List<FaceFeature> getFaceFeatures(String channelSerialnum, String frrFacePictureExt) {
        ArrayList<FaceFeature> faceFeatures = new ArrayList<FaceFeature>();
        String[] facePicArr = frrFacePictureExt.split(",");
        for (int i = 0; i < facePicArr.length; ++i) {
            List datas;
            String picStr = facePicArr[i];
            String json = (String)this.featureStorage.getItem(channelSerialnum + "/" + picStr);
            Feature feature = this.json2Feature(json);
            if (feature == null) {
                this.logger.warn("{}\u6587\u4ef6\u7684\u7279\u5f81\u83b7\u53d6\u4e0d\u5230", (Object)picStr);
                continue;
            }
            Integer face_type = feature.getFace_type();
            if (face_type != null && face_type != 1 || (datas = feature.getDatas()) == null) continue;
            Data data = new Data();
            for (int j = 0; j < datas.size(); ++j) {
                Data data1 = (Data)datas.get(j);
                if (!data1.getType().equals("server")) continue;
                data = data1;
                break;
            }
            if (data == null || data.getType() == null || data.getType().equals("camera")) continue;
            FaceFeature faceFeature = new FaceFeature();
            faceFeature.setFid(picStr);
            faceFeature.setFeature(data.getData());
            faceFeatures.add(faceFeature);
        }
        return faceFeatures;
    }

    public static void main(String[] args) {
    }
}

