/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.item.processor;

import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.ChannelSnapshot;
import com.viontech.keliu.model.VideoSnapContent;
import com.viontech.keliu.service.OrgCacheService;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.stereotype.Component;

@Component(value="channelSnapshotProcessor")
public class ChannelSnapshotProcessor
implements ItemProcessor<VideoSnapContent, ChannelSnapshot>,
ItemStream {
    @Resource
    private OrgCacheService orgCacheService;
    private ThreadLocal<ExecutionContext> executionContextThreadLocal = new ThreadLocal();

    public ChannelSnapshot process(VideoSnapContent item) throws Exception {
        ChannelSnapshot channelSnapshot = new ChannelSnapshot();
        Map channelMap = (Map)((ExecutionContext)this.executionContextThreadLocal.get()).get("channelMap");
        channelSnapshot.setDeviceSerialnum(item.getVasId());
        channelSnapshot.setChannelSerialnum(item.getVasId() + "-0" + (item.getChannelNo() + 1));
        channelSnapshot.setCountdate(item.getCounttime());
        channelSnapshot.setSnapshot(item.getFile());
        channelSnapshot.setCounttime(item.getCounttime());
        try {
            channelSnapshot.setHeight(Integer.parseInt(item.getHeight().trim()));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        try {
            channelSnapshot.setWidth(Integer.parseInt(item.getWidth().trim()));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (channelMap == null) {
            return channelSnapshot;
        }
        Channel channel = (Channel)channelMap.get(channelSnapshot.getChannelSerialnum());
        if (channel != null) {
            channelSnapshot.setDeviceId(channel.getDeviceId());
            channelSnapshot.setChannelId(channel.getId());
            channelSnapshot.setGateId(channel.getGateId());
            channelSnapshot.setMallId(channel.getMallId());
            channelSnapshot.setAccountId(channel.getAccountId());
        }
        return channelSnapshot;
    }

    public void open(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
    }

    public void update(ExecutionContext executionContext) throws ItemStreamException {
        this.executionContextThreadLocal.set(executionContext);
        Map channelMap = this.orgCacheService.getChannelMap();
        executionContext.put("channelMap", (Object)channelMap);
    }

    public void close() throws ItemStreamException {
        ExecutionContext executionContext = (ExecutionContext)this.executionContextThreadLocal.get();
        executionContext.remove("channelMap");
        this.executionContextThreadLocal.remove();
    }
}

