/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.batch.item.reader.RedisPopReader;
import com.viontech.keliu.batch.item.writer.RedisListWriter;
import com.viontech.keliu.batch.listener.ExecutionContextClearListener;
import com.viontech.keliu.batch.listener.JobRestartListener;
import com.viontech.keliu.model.FaceDataContent;
import com.viontech.keliu.redis.RedisUtil;
import com.viontech.keliu.storage.Storage;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Function;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcBatchItemWriter;
import org.springframework.batch.item.support.CompositeItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
public class RawFaceDataJobConfiguration {
    private Logger logger = LoggerFactory.getLogger(RawFaceDataJobConfiguration.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Value(value="${spring.batch.job.chunkSize:1}")
    private int chunkSize;
    @Autowired
    private Storage imageStorage;

    @Bean(name={"rawFaceDataProcessJob"})
    public Job rawFaceDataProcessJob(JobRepository jobRepository, Step rawFaceDataStep, JobRestartListener jobRestartListener) {
        return ((JobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("rawFaceDataProcessJob").listener((JobExecutionListener)jobRestartListener)).incrementer((JobParametersIncrementer)new RunIdIncrementer())).repository(jobRepository)).start(rawFaceDataStep).build();
    }

    @Bean(name={"rawFaceDataStep"})
    public Step rawFaceDataStep(RedisTemplate redisTemplate, ItemReader<FaceDataContent> rawFaceDataReader4Redis, ItemWriter<FaceDataContent> rawFaceDataCompositeWriter) {
        Function<FaceDataContent, FaceDataContent> processor = item -> {
            ArrayList<String> pictures = new ArrayList<String>();
            String faceImg = item.getFacePic();
            pictures.add(faceImg);
            String[] bodyImageName = item.getBodyImageName();
            for (String bodyPic : bodyImageName) {
                if (bodyPic == null || "".equals(bodyPic.trim())) continue;
                pictures.add(bodyPic);
            }
            for (String facePic : pictures) {
                Object pic;
                if (facePic == null || (pic = this.imageStorage.getItem(item.getChannelSerialnum() + "/" + facePic)) != null) continue;
                if (new Date().getTime() - item.getCountDate().getTime() > 600000L) {
                    this.logger.info("\u56fe\u7247\u957f\u65f6\u95f4\u4e0d\u4e0a\u4f20\uff0c\u76f4\u63a5\u5904\u7406\u6389{}", (Object)(item.getChannelSerialnum() + "/" + facePic));
                    return item;
                }
                this.logger.info("\u56fe\u7247\u8fd8\u672a\u4e0a\u4f20\uff0c\u8df3\u8fc7{}", (Object)(item.getChannelSerialnum() + "/" + facePic));
                RedisUtil.addList((String)"faceData", (Object)item);
                return null;
            }
            return item;
        };
        RepeatTemplate stepOperations = new RepeatTemplate();
        stepOperations.setCompletionPolicy((CompletionPolicy)new /* Unavailable Anonymous Inner Class!! */);
        return ((StepBuilder)this.stepBuilderFactory.get("rawFaceDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).chunk(this.chunkSize).reader(rawFaceDataReader4Redis).processor(processor).writer(rawFaceDataCompositeWriter).stepOperations((RepeatOperations)stepOperations).build();
    }

    @Bean(value={"rawFaceDataReader4Redis"})
    public ItemReader rawFaceDataReader4Redis(RedisTemplate redisTemplate) {
        RedisPopReader redisPopReader = new RedisPopReader();
        redisPopReader.setRedisTemplate(redisTemplate);
        redisPopReader.setKey("faceData");
        return redisPopReader;
    }

    @Bean(name={"rawFaceDataCompositeWriter"})
    public ItemWriter<FaceDataContent> rawFaceDataCompositeWriter(ItemWriter rawFaceData2DBWriter, ItemWriter rawFaceData2RedisWriter) {
        CompositeItemWriter compositeItemWriter = new CompositeItemWriter();
        ArrayList<ItemWriter> delegates = new ArrayList<ItemWriter>();
        delegates.add(rawFaceData2DBWriter);
        delegates.add(rawFaceData2RedisWriter);
        compositeItemWriter.setDelegates(delegates);
        return compositeItemWriter;
    }

    @Bean(name={"rawFaceData2DBWriter"})
    public ItemWriter rawFaceData2DBWriter(DataSource dataSource) {
        JdbcBatchItemWriter writer = new JdbcBatchItemWriter();
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        String sql = "INSERT INTO d_face_recognition_raw (person_unid, device_serialnum, channel_serialnum, face_pic,face_pic_ext, body_pic, body_pic_ext, showbody_pic, showbody_pic_ext, mood, age, gender, direction, counttime, countdate, status, body_feature, face_feature, track_info, track_length, track_frame_rate, happy_conf) VALUES \t\t\t\t\t\t\t\t\t\t(:personId,:vasId,:channelSerialnum,:facePic,:facePicExt,:bodyPic,:bodyPicExt,:showBodyPic,:showBodyPicExt,:mood,:age,:gender,:direction,:countDate,:countDate,:status,:bodyFeature,:faceFeature,:trackInfo,:trackLength,:trackFrameRate,:happyConf);";
        writer.setSql(sql);
        writer.setDataSource(dataSource);
        return writer;
    }

    @Bean(name={"rawFaceData2RedisWriter"})
    public ItemWriter rawFaceData2RedisWriter(RedisTemplate redisTemplate) {
        RedisListWriter writer = new RedisListWriter(redisTemplate, "faceRecognitionList");
        return writer;
    }
}

