/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.batch.item.reader.NewRegularCustomReader;
import com.viontech.keliu.batch.item.writer.FaceRecognitionJdbcBatchItemWriter;
import com.viontech.keliu.batch.item.writer.FaceRecognitionRecordJdbcBatchItemWriter;
import com.viontech.keliu.batch.listener.JobRestartListener;
import com.viontech.keliu.batch.listener.StepLoggerListener;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.support.CompositeItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class NewRegularCustomProcessJobConfiguration {
    private final Logger logger = LoggerFactory.getLogger(NewRegularCustomProcessJobConfiguration.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Value(value="${spring.batch.job.chunkSize:1}")
    private int chunkSize;

    @Bean(name={"newRegularCustomJob"})
    public Job deviceProcessJob(JobRepository jobRepository, Step newRegularCustom2DBStep, JobRestartListener jobRestartListener) {
        return ((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("newRegularCustomJob").repository(jobRepository)).incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(newRegularCustom2DBStep).build();
    }

    @Bean(name={"newRegularCustom2DBStep"})
    public Step deviceMap2RedisStep(NewRegularCustomReader newRegularCustomReader, ItemWriter faceRecognitionUpdateWriter, ItemWriter faceRecognitionRecordUpdateWriter, ItemWriter faceRecordDataSta2RedisWriter, ItemProcessor newRegularCustomProcessor) {
        CompositeItemWriter compositeItemWriter = new CompositeItemWriter();
        ArrayList<ItemWriter> delegates = new ArrayList<ItemWriter>();
        delegates.add(faceRecordDataSta2RedisWriter);
        delegates.add(faceRecognitionUpdateWriter);
        delegates.add(faceRecognitionRecordUpdateWriter);
        compositeItemWriter.setDelegates(delegates);
        return ((StepBuilder)this.stepBuilderFactory.get("faceRecord2DBStep").listener((StepExecutionListener)new StepLoggerListener())).chunk(this.chunkSize).reader((ItemReader)newRegularCustomReader).processor(newRegularCustomProcessor).writer((ItemWriter)compositeItemWriter).build();
    }

    @Bean(name={"faceRecognitionUpdateWriter"})
    public ItemWriter deviceWriter(DataSource dataSource) {
        FaceRecognitionJdbcBatchItemWriter faceRecognitionWriter = new FaceRecognitionJdbcBatchItemWriter(dataSource);
        faceRecognitionWriter.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return faceRecognitionWriter;
    }

    @Bean(name={"faceRecognitionRecordUpdateWriter"})
    public ItemWriter channelWriter(DataSource dataSource) {
        FaceRecognitionRecordJdbcBatchItemWriter faceRecognitionRecordWriter = new FaceRecognitionRecordJdbcBatchItemWriter(dataSource);
        faceRecognitionRecordWriter.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return faceRecognitionRecordWriter;
    }
}

