/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.batch.item.reader.RedisPopReader;
import com.viontech.keliu.batch.item.writer.ChannelJdbcBatchItemWriter;
import com.viontech.keliu.batch.item.writer.DeviceJdbcBatchItemWriter;
import com.viontech.keliu.batch.listener.ExecutionContextClearListener;
import com.viontech.keliu.batch.listener.JobRestartListener;
import com.viontech.keliu.batch.listener.StepLoggerListener;
import com.viontech.keliu.dao.ChannelDao;
import com.viontech.keliu.dao.DeviceDao;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.support.CompositeItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
public class DeviceProcessJobConfiguration {
    private final Logger logger = LoggerFactory.getLogger(DeviceProcessJobConfiguration.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    private int chunkSize = 1;

    @Bean(name={"deviceProcessJob"})
    public Job deviceProcessJob(JobRepository jobRepository, Step device2DBStep, JobRestartListener jobRestartListener) {
        return ((JobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("deviceProcessJob").listener((JobExecutionListener)jobRestartListener)).repository(jobRepository)).incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(device2DBStep).build();
    }

    @Bean(name={"device2DBStep"})
    public Step deviceMap2RedisStep(RedisTemplate redisTemplate, ItemWriter deviceWriter, ItemWriter channelWriter) {
        RepeatTemplate stepOperations = new RepeatTemplate();
        stepOperations.setCompletionPolicy((CompletionPolicy)new /* Unavailable Anonymous Inner Class!! */);
        RedisPopReader reader = new RedisPopReader();
        reader.setRedisTemplate(redisTemplate);
        reader.setKey("devices");
        CompositeItemWriter compositeItemWriter = new CompositeItemWriter();
        ArrayList<ItemWriter> delegates = new ArrayList<ItemWriter>();
        delegates.add(deviceWriter);
        delegates.add(channelWriter);
        compositeItemWriter.setDelegates(delegates);
        ItemProcessor deviceIpProcessor = item -> {
            String ip = item.getIp();
            String[] split = ip.split("\\.");
            if (split == null || split.length <= 0) {
                return item;
            }
            Long result = 0L;
            for (int i = 0; i < split.length; ++i) {
                result = result * 1000L + Long.valueOf(split[i]);
            }
            item.setSortIp(result);
            return item;
        };
        return ((StepBuilder)((StepBuilder)this.stepBuilderFactory.get("device2DBStep").listener((StepExecutionListener)new ExecutionContextClearListener())).listener((StepExecutionListener)new StepLoggerListener())).chunk(this.chunkSize).reader((ItemReader)reader).processor(deviceIpProcessor).writer((ItemWriter)compositeItemWriter).stepOperations((RepeatOperations)stepOperations).build();
    }

    @Bean(name={"deviceWriter"})
    public ItemWriter deviceWriter(DataSource dataSource, DeviceDao deviceDao) {
        DeviceJdbcBatchItemWriter deviceWriter = new DeviceJdbcBatchItemWriter(dataSource);
        deviceWriter.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        deviceWriter.setDeviceDao(deviceDao);
        return deviceWriter;
    }

    @Bean(name={"channelWriter"})
    public ItemWriter channelWriter(DataSource dataSource, DeviceDao deviceDao, ChannelDao channelDao) {
        ChannelJdbcBatchItemWriter channelWriter = new ChannelJdbcBatchItemWriter(dataSource);
        channelWriter.setDeviceDao(deviceDao);
        channelWriter.setChannelDao(channelDao);
        channelWriter.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return channelWriter;
    }
}

