/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.batch.configuration;

import com.viontech.keliu.batch.item.reader.RedisPopReader;
import com.viontech.keliu.batch.listener.ExecutionContextClearListener;
import com.viontech.keliu.batch.listener.JobRestartListener;
import com.viontech.keliu.batch.listener.StepLoggerListener;
import com.viontech.keliu.model.ChannelSnapshot;
import com.viontech.keliu.model.VideoSnapContent;
import com.viontech.keliu.service.OrgCacheService;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.database.BeanPropertyItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.ItemSqlParameterSourceProvider;
import org.springframework.batch.item.database.JdbcBatchItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.repeat.RepeatOperations;
import org.springframework.batch.repeat.support.RepeatTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;

@Configuration
public class ChannelSnapshotDataJobConfiguration {
    private Logger logger = LoggerFactory.getLogger(ChannelSnapshotDataJobConfiguration.class);
    @Autowired
    private JobBuilderFactory jobBuilderFactory;
    @Autowired
    private StepBuilderFactory stepBuilderFactory;
    @Autowired
    private OrgCacheService orgCacheService;
    @Value(value="${spring.batch.job.chunkSize:1}")
    private int chunkSize;

    @Bean(name={"channelSnapshotDataProcessJob"})
    public Job channelSnapshotDataProcessJob(JobRepository jobRepository, Step channelSnapshotDataStep, JobRestartListener jobRestartListener) {
        return ((JobBuilder)((JobBuilder)((JobBuilder)this.jobBuilderFactory.get("channelSnapshotDataProcessJob").listener((JobExecutionListener)jobRestartListener)).incrementer((JobParametersIncrementer)new RunIdIncrementer())).repository(jobRepository)).start(channelSnapshotDataStep).build();
    }

    @Bean(name={"channelSnapshotDataStep"})
    public Step channelSnapshotDataStep(ItemReader<VideoSnapContent> channelSnapshotDataReader4Redis, ItemProcessor<VideoSnapContent, ChannelSnapshot> channelSnapshotProcessor, ItemWriter<ChannelSnapshot> channelSnapshotData2DBWriter) {
        RepeatTemplate stepOperations = new RepeatTemplate();
        stepOperations.setCompletionPolicy((CompletionPolicy)new /* Unavailable Anonymous Inner Class!! */);
        return ((StepBuilder)((StepBuilder)this.stepBuilderFactory.get("channelSnapshotDataStep").listener((StepExecutionListener)new ExecutionContextClearListener())).listener((StepExecutionListener)new StepLoggerListener())).chunk(this.chunkSize).reader(channelSnapshotDataReader4Redis).processor(channelSnapshotProcessor).writer(channelSnapshotData2DBWriter).stepOperations((RepeatOperations)stepOperations).build();
    }

    @Bean(value={"channelSnapshotDataReader4Redis"})
    public ItemReader channelSnapshotDataReader4Redis(RedisTemplate redisTemplate) {
        RedisPopReader redisPopReader = new RedisPopReader();
        redisPopReader.setRedisTemplate(redisTemplate);
        redisPopReader.setKey("channelSnapshots");
        return redisPopReader;
    }

    @Bean(name={"channelSnapshotData2DBWriter"})
    public ItemWriter channelSnapshotData2DBWriter(DataSource dataSource) {
        String insertsql = "INSERT INTO d_channel_snapshot (device_id, device_serialnum, channel_id, channel_serialnum, width, height, snapshot, gate_id, mall_id, account_id,counttime,countdate,hour,local_ip) VALUES (:deviceId,:deviceSerialnum,:channelId,:channelSerialnum, :width, :height, :snapshot, :gateId, :mallId,:accountId,:counttime,:countdate,:hour,:localIp)";
        JdbcBatchItemWriter writer = new JdbcBatchItemWriter();
        writer.setSql(insertsql);
        writer.setDataSource(dataSource);
        writer.setItemSqlParameterSourceProvider((ItemSqlParameterSourceProvider)new BeanPropertyItemSqlParameterSourceProvider());
        return writer;
    }
}

