package com.viontech.keliu.util;


import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.enums.HttpRespCodeEnum;
import sun.misc.BASE64Decoder;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;


/**
 * @author 谢明辉
 */

public class Util {
    public static final ThreadPoolExecutor POOL_EXECUTOR = new ThreadPoolExecutor(5, 20, 1, TimeUnit.MINUTES, new LinkedBlockingQueue<>());

    public static String FILE_BASE_DIR = System.getProperty("user.dir") + File.separator + "file" + File.separator;

    /**
     * 将json字符串转换为map
     *
     * @param jsonStr 需要变为map的json字符串
     * @return java.util.HashMap
     */
    public static HashMap json2Map(String jsonStr) throws IOException {
        if (jsonStr == null || "".equals(jsonStr)) {
            return new HashMap(0);
        }
        ObjectMapper mapper = new ObjectMapper();

        return mapper.readValue(jsonStr, HashMap.class);
    }

    /**
     * @param code 注册成功后返回的operationCode
     * @return java.lang.String
     */
    public static String successResponse(int code, String msg) throws JsonProcessingException {
        Map<String, Object> msgMap = new HashMap<>();
        msgMap.put("operCode", code);
        msgMap.put("operMsg", msg);
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(msgMap);
    }

    public static JsonMessageUtil.JsonMessage getErrorMessage(HttpRespCodeEnum httpRespCodeEnum) {
        return JsonMessageUtil.getErrorJsonMsg(httpRespCodeEnum.code, httpRespCodeEnum.msg);
    }

    /**
     * 将base64文件编码保存成文件
     *
     * @param fileName   保存的文件路径
     * @param fileBase64 需要保存的数据的base64编码
     */
    public static void saveFile(String fileName, String fileBase64) throws IOException {
        File file = new File(Util.FILE_BASE_DIR + fileName);
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] bytes = decoder.decodeBuffer(fileBase64);

        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(bytes);
        fos.close();
    }

}
