package com.viontech.keliu.service;


import com.fasterxml.jackson.databind.ObjectMapper;
import com.viontech.keliu.enums.FlagEnums;
import com.viontech.keliu.util.HttpUtil;
import com.viontech.keliu.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;


/**
 * @author 谢明辉
 */

@Service
public class ForwardService {

    private Logger log = LoggerFactory.getLogger(ForwardService.class);
    @Resource
    private ObjectMapper objectMapper;

    /**
     * 将request转为json字符串
     *
     * @param request 请求
     * @param flag    指令flag
     * @return java.lang.String
     */
    public String request2String(HttpServletRequest request, FlagEnums flag) throws IOException {
        // 将请求转换为协议中的格式
        Map<String, Object> requestMap = HttpUtil.requestConvert2Map(request);
        Map<String, Object> dataMap = new HashMap<>();

        // 判断请求的类型，添加相应的
        if (flag != FlagEnums.GENERAL_FLAG) {
            dataMap.put("command", flag.command);
        }

        //如果是升级指令，需要把升级包base64编码
        if (flag == FlagEnums.UPLOAD_FLAG) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
            MultipartFile formdata = multipartRequest.getFile("formdata");
            if (formdata == null) {
                throw new RuntimeException("无法获取升级文件");
            }
            String filename = formdata.getOriginalFilename();
            String url = (String) requestMap.get("uri");
            Map<String, String> fileMap = new HashMap<>();
            fileMap.put("file_name", filename);
            fileMap.put("url", url);
            byte[] fileBytes = formdata.getBytes();
            byte[] fileMapBytes = objectMapper.writeValueAsBytes(fileMap);
            byte[] bytes = new byte[512 + fileBytes.length];

            System.arraycopy(fileMapBytes, 0, bytes, 0, fileMapBytes.length);
            System.arraycopy(fileBytes, 0, bytes, 512, fileBytes.length);
            return Base64.getEncoder().encodeToString(bytes);
        }
        dataMap.put("request", requestMap);
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(dataMap);
    }


    /**
     * 下载截图（以后将路径提出来做成下载文件）
     */
    public void downloadFile(HttpServletRequest request, HttpServletResponse response) throws IOException {

        String fileName = request.getParameter("name");
        Path path = Paths.get(System.getProperty("user.dir") + File.separator + "file" + File.separator + fileName);

        if (!Files.exists(path)) {
            throw new RuntimeException("文件不存在");
        }

        log.info("用户访问了文件，文件名:{}", path.getFileName().toString());
        response.setHeader("content-type", "application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(path.getFileName().toString(), "UTF-8"));
        Files.copy(path, response.getOutputStream());
    }

    public Object saveOtherFileFromResponse(HashMap deviceResponse, String serialnum) throws IOException {
        String fileName = (String) deviceResponse.get("file_name");
        String responseBodyStr = (String) deviceResponse.get("response_body");
        HashMap trueBody = Util.json2Map(responseBodyStr);

        String base64File = (String) trueBody.get("download");
        fileName = serialnum + "_" + System.currentTimeMillis() + "_" + fileName;
        Util.saveFile(fileName, base64File);

        String url = "/file?name=" + fileName;
        trueBody.put("download", url);

        log.info("用户访问了下载文件功能，文件保存为:{}" + fileName);
        return trueBody;
    }

    public Object saveScreenShotFromResponse(HashMap deviceResponse, String serialnum) throws IOException {
        HashMap responseBody;
        try {
            String responseBodyStr = (String) deviceResponse.get("response_body");
            try {
                responseBody = Util.json2Map(responseBodyStr);
            } catch (Exception e) {
                e.printStackTrace();
                responseBody = (HashMap) deviceResponse.get("response_body");
            }
        } catch (Exception e) {
            return deviceResponse.get("response_body");
        }

        HashMap data = (HashMap) responseBody.get("data");
        String img = (String) data.get("img");
        //       对截图的返回response中的img进行处理，先用base64解码，保存成本地文件，返回文件的url
        String fileName = serialnum + "_" + System.currentTimeMillis() + ".jpg";
        Util.saveFile(fileName, img);

        String url = "/file?name=" + fileName;
        data.put("img", url);
        log.info("用户访问了截图功能，截图保存为:{}" + fileName);
        return responseBody;
    }
}
