package com.viontech.keliu.netty;


import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;


/**
 * @author 谢明辉
 */

@Component
public class NettyServer {

    @Value("${netty.port}")
    private int port;
    @Value("${netty.ip:}")
    private String ip;

    private Logger logger = LoggerFactory.getLogger(NettyServer.class);

    public void run() {
        EventLoopGroup workerGroup = new NioEventLoopGroup(30);

        try {

            ServerBootstrap b = new ServerBootstrap();
            b = b.group(workerGroup)
                    .channel(NioServerSocketChannel.class)
                    .childHandler(new ChannelInitializer<SocketChannel>() {
                        @Override
                        protected void initChannel(SocketChannel ch) throws Exception {
                            ch.pipeline().addLast(new LengthFieldBasedFrameDecoder(1024 * 1024 * 10, 0, 4, -4, 0));
                            ch.pipeline().addLast(new ByteToMessageHandler());
                            ch.pipeline().addLast(new NettyReceiverHandler());

                        }
                    })
                    .option(ChannelOption.SO_BACKLOG, 128)
                    .childOption(ChannelOption.SO_KEEPALIVE, true);
            logger.info("通道构建完毕");

            ChannelFuture f;
            if (ip.isEmpty()) {
                logger.info("开始启动netty服务器, 端口: {}", port);
                f = b.bind(port).sync();
            } else {
                logger.info("开始启动netty服务器, IP端口: {}:{}", ip, port);
                f = b.bind(ip, port).sync();
            }

            f.channel().closeFuture().sync();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
