package com.viontech.keliu.netty;


import com.viontech.keliu.enums.CodeEnum;
import com.viontech.keliu.model.DeviceInfo;
import com.viontech.keliu.model.Message;
import com.viontech.keliu.util.Util;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;


/**
 * @author 谢明辉
 */

public class NettyReceiverHandler extends ChannelInboundHandlerAdapter {

    private Logger log = LoggerFactory.getLogger(NettyReceiverHandler.class);


    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        log.info("channelRegistered----------------");
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Message message = (Message) msg;
        if (message.getData().length < 20480) {
            log.info("\n收到响应:\nCommandID : {}\nMessageID : {}\nMessage:{}", message.getCommand(), message.getId(), message.getUTF8StringData());
        }
        //注册命令
        if (message.getCommand() == CodeEnum.COMMAND_REGISTERED.value) {
            //设备注册
            HashMap map = Util.json2Map(message.getUTF8StringData());
            String serialNum = map.get("serialNum").toString();
            ChannelGroup.registered(serialNum, ctx.channel());
            ChannelGroup.HEART_BEAT_MAP.put(serialNum, System.currentTimeMillis());

            String ip = map.get("deviceIP") == null ? null : map.get("deviceIP").toString();
            String type = map.get("deviceType") == null ? null : map.get("deviceType").toString();

            ChannelGroup.DEVICE_INFO_MAP.put(serialNum, new DeviceInfo(serialNum, ip, type));
            //返回信息
            String dataStr = Util.successResponse(0, "注册成功");
            message.setUTF8StringData(dataStr);
            ctx.channel().writeAndFlush(message);
        }
        //控制命令
        else if (message.getCommand() == CodeEnum.COMMAND_CONTROL.value && ChannelGroup.ID_DATA_MAP.containsKey(message.getId())) {
            ChannelGroup.ID_DATA_MAP.put(message.getId(), message.getUTF8StringData());
        }
        //通用命令
        else if (message.getCommand() == CodeEnum.COMMAND_GENERAL_COMMAND.value) {
            //得到 command
            HashMap map = Util.json2Map(message.getUTF8StringData());
            String command = (String) map.get("command");

            //根据command进行任务
            switch (command) {
                //心跳
                case "keep-alive":
                    log.info("收到心跳");
                    String dataStr = Util.successResponse(0, "收到心跳");
                    message.setUTF8StringData(dataStr);
                    String serialnum;
                    if ((serialnum = ChannelGroup.getSerialnum(ctx.channel())) != null) {
                        ChannelGroup.HEART_BEAT_MAP.put(serialnum, System.currentTimeMillis());
                    }
                    Util.POOL_EXECUTOR.execute(() -> {
                        try {
                            ctx.channel().writeAndFlush(message).sync();
                        } catch (Exception e) {
                            log.error("无法回应心跳", e);
                        }
                    });
                    log.info("已响应心跳");
                    break;
//                //截图
//                case "process-image":
//                    //升级固件
//                case "update":
//                    if (ChannelGroup.ID_DATA_MAP.containsKey(message.getId())) {
//                        ChannelGroup.ID_DATA_MAP.put(message.getId(), message.getUTF8StringData());
//                    }
//                    break;
                default:
                    if (ChannelGroup.ID_DATA_MAP.containsKey(message.getId())) {
                        ChannelGroup.ID_DATA_MAP.put(message.getId(), message.getUTF8StringData());
                    }
            }


        }

    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        cause.printStackTrace();
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        log.info("断开连接:{}", ctx.channel().id().toString());
        ChannelGroup.unregistered(ctx.channel());
    }

}
