package com.viontech.keliu.netty;


import com.viontech.keliu.model.Message;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.ReferenceCountUtil;

import java.util.List;


/**
 * @author 谢明辉
 */

public class ByteToMessageHandler extends ByteToMessageCodec<Message> {

    @Override
    protected void encode(ChannelHandlerContext ctx, Message msg, ByteBuf out) throws Exception {
        ByteBuf byteBuf = msg.parse2ByteBuf();
        out.writeBytes(byteBuf);
        ReferenceCountUtil.release(byteBuf);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        out.add(new Message(in));
    }
}
