package com.viontech.keliu.model;


import com.viontech.keliu.netty.ChannelGroup;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;


/**
 * @author 谢明辉
 */

public class MsgID {

    private static AtomicInteger id = new AtomicInteger();
    private static Lock lock = new ReentrantLock(true);

    public static int getId() {
        int num = id.getAndIncrement();

        lock.lock();
        try {
            if (num == Integer.MAX_VALUE) {
                id.set(0);
            }
            while (ChannelGroup.ID_DATA_MAP.containsKey(num)) {
                num = id.getAndIncrement();
            }
        } finally {
            lock.unlock();
        }

        return num;
    }

}
