package com.viontech.keliu.model;


import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;

import java.nio.charset.Charset;


/**
 * @author 谢明辉
 */

public class Message {

    /** length只能通过setData时才能改变,代表整条消息的长度 */
    private int length;
    private int version;
    private int command;
    private int id;
    private byte[] data;


    public int length() {
        return length;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getCommand() {
        return command;
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public byte[] getData() {
        return data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.length = this.data.length + 9;
    }


    @Override
    public String toString() {
        return "Message{" +
                "length=" + length +
                ", version=" + version +
                ", command=" + command +
                ", id=" + id +
                ", data='" + getUTF8StringData() + '\'' +
                '}';
    }


    public Message() {
    }

    public Message(int version, int command, int id, byte[] data) {
        this.version = version;
        this.command = command;
        this.id = id;
        this.data = data;
        this.length = this.data.length + 9;
    }

    public String getStringData(String charset) {
        return new String(this.data, Charset.forName(charset));
    }

    public String getUTF8StringData() {
        return getStringData("utf-8");
    }

    public void setStringData(String data, String charset) {
        this.data = data.getBytes(Charset.forName(charset));
        this.length = this.data.length + 9;
    }

    public void setUTF8StringData(String data) {
        setStringData(data, "utf-8");
    }


    /**
     * 根据byteBuf构建Message
     *
     * @param byteBuf 需要被转换的byteBuf
     */
    public Message(ByteBuf byteBuf) {

        // 解析消息长度
        byte lengthByte1 = byteBuf.readByte();
        byte lengthByte2 = byteBuf.readByte();
        byte lengthByte3 = byteBuf.readByte();
        byte lengthByte4 = byteBuf.readByte();
        this.length = ((lengthByte1 & 0xff) << 24) | ((lengthByte2 & 0xff) << 16) | ((lengthByte3 & 0xff) << 8) | ((lengthByte4 & 0xff));

        byte b = byteBuf.readByte();
        // 解析消息版本，指令类型，消息id，数据
        this.version = (b & 0xf0) >> 4;
        this.command = b & 0x0f;
        this.id = byteBuf.readInt();
        this.data = new byte[this.length - 9];
        byteBuf.readBytes(this.data, 0, this.length - 9);
    }

    /**
     * 将消息转为ByteBuf
     *
     * @return io.netty.buffer.ByteBuf
     */
    public ByteBuf parse2ByteBuf() {
        // 得到数据数组和数据长度
        //        byte[] data = this.data.getBytes(Charset.forName("utf-8"));
        int length = this.length + 1;

        // 最终需要被构造的消息数组
        byte[] bytes = new byte[length];
        // 消息长度
        bytes[0] = (byte) (length >> 24 & 0xff);
        bytes[1] = (byte) (length >> 16 & 0xff);
        bytes[2] = (byte) (length >> 8 & 0xff);
        bytes[3] = (byte) (length & 0xff);

        // 协议版本（0） & 指令
        int command = this.command;
        bytes[4] = (byte) (command & 0x0f);

        // 消息ID
        bytes[5] = (byte) (this.id >> 24 & 0xff);
        bytes[6] = (byte) (this.id >> 16 & 0xff);
        bytes[7] = (byte) (this.id >> 8 & 0xff);
        bytes[8] = (byte) (this.id & 0xff);

        // 复制数据到消息数组的尾部
        System.arraycopy(this.data, 0, bytes, 9, this.data.length);

        bytes[this.length] = '\0';

        // 得到需要的byteBuf
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(bytes.length);
        return buf.writeBytes(bytes);
    }
}
