/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.dao.FaceRecognitionDao;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.util.DateUtil;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ClearService {
    private final Logger logger = LoggerFactory.getLogger(ClearService.class);
    @Value(value="#{'${vion.delMall.unids:}'.split(',')}")
    private List<String> delMallUnids;
    @Resource
    private FaceRecognitionDao faceRecognitionDao;
    @Resource
    private Storage imageStorage;

    public void delete() throws ParseException {
        this.delete(null);
    }

    public void delete(Date date) throws ParseException {
        List mallIds = this.faceRecognitionDao.selectMallIdByUnid(this.delMallUnids);
        mallIds.forEach(item -> this.deleteByMallId(item, date));
    }

    public void deleteByMallId(Long mallId) {
        this.deleteByMallId(mallId, null);
    }

    public void deleteByMallId(Long mallId, Date countdate) {
        Date modifytime;
        if (countdate != null) {
            modifytime = DateUtil.truncate((Date)countdate, (int)5);
        } else {
            modifytime = (Date)this.faceRecognitionDao.getModifyTimeMap().get(mallId);
            if (modifytime == null) {
                modifytime = DateUtil.truncate((Date)new Date(), (int)5);
            }
        }
        int page = 1;
        while (true) {
            List faceRecognitions;
            if ((faceRecognitions = this.faceRecognitionDao.selectFaceRecognition(mallId, modifytime, page, 1000)) == null || faceRecognitions.isEmpty()) {
                if (page <= 1) break;
                this.logger.info("{}-{} \u6570\u636e\u5904\u7406\u5b8c\u6210", (Object)mallId, (Object)modifytime);
                break;
            }
            this.faceRecognitionDao.getModifyTimeMap().put(mallId, ((FaceRecognition)faceRecognitions.get(0)).getModifyTime());
            for (FaceRecognition faceRecognition : faceRecognitions) {
                this.deleteImage(faceRecognition);
            }
            ++page;
        }
    }

    public void deleteImage(FaceRecognition faceRecognition) {
        boolean isDelete = false;
        String facePicExt = faceRecognition.getFacePicExt();
        String[] facePicExtArr = facePicExt.substring(1, facePicExt.length() - 1).split(",");
        for (int i = 0; i < facePicExtArr.length; ++i) {
            String picName = facePicExtArr[i].trim();
            if ("null".equals(picName)) continue;
            isDelete = this.imageStorage.deleteItem(faceRecognition.getChannelSerialnum() + "/" + picName);
            if (isDelete) {
                this.logger.info("{}\u4eba\u8138\u56fe\u7247\u5220\u9664\u6210\u529f", (Object)facePicExtArr[i]);
                continue;
            }
            this.logger.warn("{}\u4eba\u8138\u56fe\u7247\u5220\u9664\u5931\u8d25", (Object)facePicExtArr[i]);
        }
        String bodyPicExt = faceRecognition.getBodyPicExt();
        String[] bodyPicExtArr = bodyPicExt.substring(1, bodyPicExt.length() - 1).split(",");
        for (int i = 0; i < bodyPicExtArr.length; ++i) {
            String picName = bodyPicExtArr[i].trim();
            if ("null".equals(picName)) continue;
            isDelete = this.imageStorage.deleteItem(faceRecognition.getChannelSerialnum() + "/" + bodyPicExtArr[i].trim());
            if (isDelete) {
                this.logger.info("{}\u4eba\u4f53\u56fe\u7247\u5220\u9664\u6210\u529f", (Object)bodyPicExtArr[i]);
                continue;
            }
            this.logger.warn("{}\u4eba\u8138\u56fe\u7247\u5220\u9664\u5931\u8d25", (Object)bodyPicExtArr[i]);
        }
    }
}

