/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.dao;

import com.viontech.keliu.model.FaceRecognition;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class FaceRecognitionDao {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private Map<Long, Date> modifyTimeMap;
    private final String SQL_SELECT_VALUE = "select value from s_config_params where mall_id is null and key='privacyConfig' order by id";
    private final String SQL_SELECT_MALLID = "select id from b_mall where status=1";
    private final String SQL_SELECT_OPEN_MALLID = "select DISTINCT mall_id from s_config_params where mall_id is not null and key='privacyConfig' and value = '1'";
    private final String SQL_SELECT_CLOSE_MALLID = "select DISTINCT mall_id from s_config_params where mall_id is not null and key='privacyConfig' and value = '0'";
    private final String SQL_SELECT_FACERECOGNITION = "select channel_serialnum as channelSerialnum,modify_time as modifyTime,face_pic_ext as facePicExt,body_pic_ext as bodyPicExt from d_face_recognition where mall_id = ? and countdate = ? and modify_time > ? order by modify_time desc limit ? offset ? ";

    public Map<Long, Date> getModifyTimeMap() {
        if (this.modifyTimeMap == null) {
            this.modifyTimeMap = new HashMap();
        }
        return this.modifyTimeMap;
    }

    public void setModifyTimeMap(Map<Long, Date> modifyTimeMap) {
        this.modifyTimeMap = modifyTimeMap;
    }

    public List<Long> selectMallId() {
        return this.jdbcTemplate.queryForList("select id from b_mall where status=1", Long.class);
    }

    public List<Long> selectMallIdByUnid(List<String> mallUnids) {
        if (mallUnids.size() <= 0) {
            return Collections.emptyList();
        }
        StringBuilder sqlSb = new StringBuilder("select id from b_mall where unid in(");
        mallUnids.stream().forEach(item -> sqlSb.append("'").append((String)item).append("'").append(","));
        sqlSb.setCharAt(sqlSb.length() - 1, ')');
        return this.jdbcTemplate.queryForList(sqlSb.toString(), Long.class);
    }

    public List<Long> selectNotNullAndOpenPrivacy() {
        return this.jdbcTemplate.queryForList("select DISTINCT mall_id from s_config_params where mall_id is not null and key='privacyConfig' and value = '1'", Long.class);
    }

    public List<Long> selectNotNullAndClosePrivacy() {
        return this.jdbcTemplate.queryForList("select DISTINCT mall_id from s_config_params where mall_id is not null and key='privacyConfig' and value = '0'", Long.class);
    }

    public List<FaceRecognition> selectFaceRecognition(Long mallId, Date modifytime, int page, int pageSize) {
        return this.jdbcTemplate.query("select channel_serialnum as channelSerialnum,modify_time as modifyTime,face_pic_ext as facePicExt,body_pic_ext as bodyPicExt from d_face_recognition where mall_id = ? and countdate = ? and modify_time > ? order by modify_time desc limit ? offset ? ", new Object[]{mallId, modifytime, modifytime, pageSize, (page - 1) * pageSize}, (RowMapper)new BeanPropertyRowMapper(FaceRecognition.class));
    }

    public String selectDefaultValue() {
        List values = this.jdbcTemplate.queryForList("select value from s_config_params where mall_id is null and key='privacyConfig' order by id", String.class);
        if (values == null || values.isEmpty()) {
            return "0";
        }
        return (String)values.get(0);
    }
}

