package com.viontech.keliu.service;

import com.viontech.keliu.dao.FaceRecognitionDao;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@Service
public class ClearService {

    private final Logger logger  = LoggerFactory.getLogger(ClearService.class);

    @Value("#{'${vion.delMall.unids:}'.split(',')}")
    private List<String> delMallUnids;
    @Resource
    private FaceRecognitionDao faceRecognitionDao;

    @Resource
    private Storage imageStorage;

    public void delete() throws ParseException {
      delete(null);
    }

    public void delete(Date date) throws ParseException {
       /* List<Long> mallIds;
        if(faceRecognitionDao.selectDefaultValue().equals("0")){// 如果默认关闭隐私模式
            mallIds=faceRecognitionDao.selectNotNullAndOpenPrivacy();// 得到所有开启隐私模式的商场
        }else{ // 如果默认开启 需要拿到所有商场 然后去掉关闭隐私模式的商场 剩下的就是开启了隐私模式的商场
            mallIds=faceRecognitionDao.selectMallId();
            List<Long> mallIdlist=faceRecognitionDao.selectNotNullAndClosePrivacy();
            mallIds = mallIds.stream().filter(item->!mallIdlist.contains(item)).collect(Collectors.toList());
        }
        if(mallIds == null || mallIds.isEmpty()){
            logger.warn("没有开启隐私模式的商场");
            return;
        }
        StringBuilder sb = new StringBuilder();
        mallIds.forEach(item->{
           sb.append(item).append(",");
        });
        System.out.println(sb.toString());*/
        List<Long> mallIds = faceRecognitionDao.selectMallIdByUnid(delMallUnids);
        mallIds.forEach(item->deleteByMallId(item,date));
    }

    public void deleteByMallId(Long mallId)  {
        this.deleteByMallId(mallId,null);
    }
    public void deleteByMallId(Long mallId,Date countdate)  {
        Date modifytime;
        List<FaceRecognition> faceRecognitions;
        if(countdate != null){
            modifytime=DateUtil.truncate(countdate, Calendar.DAY_OF_MONTH);// 如果查找不到modifyTime 那么 从凌晨开始查
        }else{
            modifytime=faceRecognitionDao.getModifyTimeMap().get(mallId);
            if (modifytime == null) {
                modifytime=DateUtil.truncate(new Date(), Calendar.DAY_OF_MONTH);// 如果查找不到modifyTime 那么 从凌晨开始查
            }
        }

        int page=1;
        while(true){
            faceRecognitions=faceRecognitionDao.selectFaceRecognition(mallId,modifytime,page,1000);
            if(faceRecognitions==null || faceRecognitions.isEmpty()){
                if(page>1) {
                    logger.info("{}-{} 数据处理完成", mallId, modifytime);
                }
                break;
            }

            faceRecognitionDao.getModifyTimeMap().put(mallId,faceRecognitions.get(0).getModifyTime());
            for (FaceRecognition faceRecognition : faceRecognitions) {
                deleteImage(faceRecognition);
            }
            page++;
        }
    }

    public void deleteImage(FaceRecognition faceRecognition){
        boolean isDelete = false;
        String facePicExt=faceRecognition.getFacePicExt();
        String[] facePicExtArr=facePicExt.substring(1,facePicExt.length()-1).split(",");
        for(int i=0;i<facePicExtArr.length;i++){
            String  picName = facePicExtArr[i].trim();
            if("null".equals(picName)){
                continue;
            }
            isDelete=imageStorage.deleteItem(faceRecognition.getChannelSerialnum() + "/" + picName);
            if(isDelete){
                logger.info("{}人脸图片删除成功",facePicExtArr[i]);
            }else{
                logger.warn("{}人脸图片删除失败",facePicExtArr[i]);
            }
        }
        String bodyPicExt=faceRecognition.getBodyPicExt();
        String[] bodyPicExtArr=bodyPicExt.substring(1,bodyPicExt.length()-1).split(",");
        for(int i=0;i<bodyPicExtArr.length;i++){
            String  picName =bodyPicExtArr[i].trim();
            if("null".equals(picName)){
                continue;
            }
            isDelete=imageStorage.deleteItem(faceRecognition.getChannelSerialnum() + "/" + bodyPicExtArr[i].trim());
            if(isDelete){
                logger.info("{}人体图片删除成功",bodyPicExtArr[i]);
            }else{
                logger.warn("{}人脸图片删除失败",bodyPicExtArr[i]);
            }
        }
    }
}
