package com.viontech.keliu.dao;

import com.viontech.keliu.model.FaceRecognition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

import javax.annotation.Resource;
import java.util.*;

@Repository
public class FaceRecognitionDao {

    @Resource
    private JdbcTemplate jdbcTemplate;

    private Map<Long,Date> modifyTimeMap;

    public Map<Long, Date> getModifyTimeMap() {
        if(modifyTimeMap==null){
            modifyTimeMap=new HashMap<>();
        }
        return modifyTimeMap;
    }

    public void setModifyTimeMap(Map<Long, Date> modifyTimeMap) {
        this.modifyTimeMap = modifyTimeMap;
    }

    private final String SQL_SELECT_VALUE="select value from s_config_params where mall_id is null and key='privacyConfig' order by id";
    private final String SQL_SELECT_MALLID="select id from b_mall where status=1";
    private final String SQL_SELECT_OPEN_MALLID="select DISTINCT mall_id from s_config_params where mall_id is not null and key='privacyConfig' and value = '1'";
    private final String SQL_SELECT_CLOSE_MALLID="select DISTINCT mall_id from s_config_params where mall_id is not null and key='privacyConfig' and value = '0'";
    private final String SQL_SELECT_FACERECOGNITION="select channel_serialnum as channelSerialnum,modify_time as modifyTime,face_pic_ext as facePicExt,body_pic_ext as bodyPicExt from d_face_recognition where mall_id = ? and countdate = ? and modify_time > ? order by modify_time desc limit ? offset ? ";


    public List<Long> selectMallId(){
        return jdbcTemplate.queryForList(SQL_SELECT_MALLID,Long.class);
    }

    public List<Long> selectMallIdByUnid(List<String> mallUnids){
        if(mallUnids.size()<=0){
            return Collections.emptyList();
        }
        StringBuilder sqlSb = new StringBuilder("select id from b_mall where unid in(");

        mallUnids.stream().forEach(item ->{
                sqlSb.append("'").append(item).append("'").append(",");

        });
        sqlSb.setCharAt(sqlSb.length()-1,')');
        return jdbcTemplate.queryForList(sqlSb.toString(),Long.class);

    }

    public List<Long> selectNotNullAndOpenPrivacy(){
        return jdbcTemplate.queryForList(SQL_SELECT_OPEN_MALLID,Long.class);
    }

    public List<Long> selectNotNullAndClosePrivacy(){
        return jdbcTemplate.queryForList(SQL_SELECT_CLOSE_MALLID,Long.class);
    }



    public List<FaceRecognition> selectFaceRecognition(Long mallId,Date modifytime,int page,int pageSize){
        return jdbcTemplate.query(SQL_SELECT_FACERECOGNITION,new Object[]{mallId,modifytime,modifytime,pageSize,(page-1)*pageSize},new BeanPropertyRowMapper<>(FaceRecognition.class));
    }

    public String selectDefaultValue(){
        List<String> values=jdbcTemplate.queryForList(SQL_SELECT_VALUE,String.class);
        if(values==null||values.isEmpty()){
            return "0";
        }
        return values.get(0);
    }
}
